﻿---
title: Specialized queries
description: This group contains queries which do not fit into the other groups: 
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/specialized-queries
products:
  - Elasticsearch
---

# Specialized queries
This group contains queries which do not fit into the other groups:
<definitions>
  <definition term="distance_feature query">
    A query that computes scores based on the dynamically computed distances between the origin and documents' `date`, `date_nanos`, and `geo_point` fields. It is able to efficiently skip non-competitive hits.
  </definition>
  <definition term="more_like_this query">
    This query finds documents which are similar to the specified text, document, or collection of documents.
  </definition>
  <definition term="percolate query">
    This query finds queries that are stored as documents that match with the specified document.
  </definition>
  <definition term="rank_feature query">
    A query that computes scores based on the values of numeric features and is able to efficiently skip non-competitive hits.
  </definition>
  <definition term="script query">
    This query allows a script to act as a filter. Also see the [`function_score` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-function-score-query).
  </definition>
  <definition term="script_score query">
    A query that allows to modify the score of a sub-query with a script.
  </definition>
  <definition term="wrapper query">
    A query that accepts other queries as json or yaml string.
  </definition>
  <definition term="pinned query">
    A query that promotes selected documents over others matching a given query.
  </definition>
  <definition term="rule query">
    A query that supports applying query-based contextual rules, defined using the [Query Rules API](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-query_rules), to a given query.
  </definition>
</definitions>