﻿---
title: Span queries
description: Span queries are low-level positional queries which provide expert control over the order and proximity of the specified terms. These are typically used...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/span-queries
products:
  - Elasticsearch
---

# Span queries
Span queries are low-level positional queries which provide expert control over the order and proximity of the specified terms. These are typically used to implement very specific queries on legal documents or patents.
It is only allowed to set boost on an outer span query. Compound span queries, like span_near, only use the list of matching spans of inner span queries in order to find their own spans, which they then use to produce a score. Scores are never computed on inner span queries, which is the reason why boosts are not allowed: they only influence the way scores are computed, not spans.
Span queries cannot be mixed with non-span queries (with the exception of the `span_multi` query).
The queries in this group are:
<definitions>
  <definition term="span_containing query">
    Accepts a list of span queries, but only returns those spans which also match a second span query.
  </definition>
  <definition term="span_field_masking query">
    Allows queries like `span-near` or `span-or` across different fields.
  </definition>
  <definition term="span_first query">
    Accepts another span query whose matches must appear within the first N positions of the field.
  </definition>
  <definition term="span_multi query">
    Wraps a [`term`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query), [`range`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-range-query), [`prefix`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-prefix-query), [`wildcard`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-wildcard-query), [`regexp`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-regexp-query), or [`fuzzy`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-fuzzy-query) query.
  </definition>
  <definition term="span_near query">
    Accepts multiple span queries whose matches must be within the specified distance of each other, and possibly in the same order.
  </definition>
  <definition term="span_not query">
    Wraps another span query, and excludes any documents which match that query.
  </definition>
  <definition term="span_or query">
    Combines multiple span queries — returns documents which match any of the specified queries.
  </definition>
  <definition term="span_term query">
    The equivalent of the [`term` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query) but for use with other span queries.
  </definition>
  <definition term="span_within query">
    The result from a single span query is returned as long is its span falls within the spans returned by a list of other span queries.
  </definition>
</definitions>