﻿---
title: Shape queries
description: Like geo_shape Elasticsearch supports the ability to index arbitrary two dimension (non Geospatial) geometries making it possible to map out virtual worlds,...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/shape-queries
products:
  - Elasticsearch
---

# Shape queries
Like [`geo_shape`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape) Elasticsearch supports the ability to index arbitrary two dimension (non Geospatial) geometries making it possible to map out virtual worlds, sporting venues, theme parks, and CAD diagrams.
Elasticsearch supports two types of cartesian data: [`point`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/point) fields which support x/y pairs, and [`shape`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/shape) fields, which support points, lines, circles, polygons, multi-polygons, etc.
The queries in this group are:
<definitions>
  <definition term="shape query">
    Finds documents with:
    - `shapes` which either intersect, are contained by, are within or do not intersect with the specified shape
    - `points` which intersect the specified shape
  </definition>
</definitions>