﻿---
title: Regular expression syntax
description: A regular expression is a way to match patterns in data using placeholder characters, called operators. Elasticsearch supports regular expressions in...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/regexp-syntax
products:
  - Elasticsearch
---

# Regular expression syntax
A [regular expression](https://en.wikipedia.org/wiki/Regular_expression) is a way to match patterns in data using placeholder characters, called operators.
Elasticsearch supports regular expressions in the following queries:
- [`regexp`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-regexp-query)
- [`query_string`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-query-string-query)

Elasticsearch uses [Apache Lucene](https://lucene.apache.org/core/)'s regular expression engine to parse these queries.

## Reserved characters

Lucene’s regular expression engine supports all Unicode characters. However, the following characters are reserved as operators:
```
. ? + * | { } [ ] ( ) " \
```

Depending on the [optional operators](#regexp-optional-operators) enabled, the following characters may also be reserved:
```
# @ & < >  ~
```

To use one of these characters literally, escape it with a preceding backslash or surround it with double quotes. For example:
```
\@                 
\\                 
"john@smith.com"   
```

<note>
  The backslash is an escape character in both JSON strings and regular expressions. You need to escape both backslashes in a query, unless you use a language client, which takes care of this. For example, the string `a\b` needs to be indexed as `"a\\b"`:
  ```json

  {
    "my_field": "a\\b"
  }
  ```
  This document matches the following `regexp` query:
  ```json

  {
    "query": {
      "regexp": {
        "my_field.keyword": "a\\\\.*"
      }
    }
  }
  ```
</note>


## Standard operators

Lucene’s regular expression engine does not use the [Perl Compatible Regular Expressions (PCRE)](https://en.wikipedia.org/wiki/Perl_Compatible_Regular_Expressions) library, but it does support the following standard operators.
<definitions>
  <definition term=".">
    Matches any character. For example:
  </definition>
</definitions>

```
ab.    
```

<definitions>
  <definition term="?">
    Repeat the preceding character zero or one times. Often used to make the preceding character optional. For example:
  </definition>
</definitions>

```
abc?    
```

<definitions>
  <definition term="+">
    Repeat the preceding character one or more times. For example:
  </definition>
</definitions>

```
ab+    
```

<definitions>
  <definition term="*">
    Repeat the preceding character zero or more times. For example:
  </definition>
</definitions>

```
ab*    
```

<definitions>
  <definition term="{}">
    Minimum and maximum number of times the preceding character can repeat. For example:
  </definition>
</definitions>

```
a{{2}}   
a{2,4} 
a{2,}  
```

<definitions>
  <definition term="|">
    OR operator. The match will succeed if the longest pattern on either the left side OR the right side matches. For example:
  </definition>
</definitions>

```
abc|xyz 
```

<definitions>
  <definition term="( … )">
    Forms a group. You can use a group to treat part of the expression as a single character. For example:
  </definition>
</definitions>

```
abc(def)? 
```

<definitions>
  <definition term="[ … ]">
    Match one of the characters in the brackets. For example:
  </definition>
</definitions>

```
[abc]  
```

Inside the brackets, `-` indicates a range unless `-` is the first character or escaped. For example:
```
[a-c]  
[-abc] 
[abc\-]
```

A `^` before a character in the brackets negates the character or range. For example:
```
[^abc]     
[^a-c]     
[^-abc]    
[^abc\-]   
```

<note>
  Character range classes such as `[a-c]` do not behave as expected when using `case_insensitive: true` — they remain case sensitive. For example, `[a-c]+` with `case_insensitive: true` will match strings containing only the characters 'a', 'b', and 'c', but not 'A', 'B', or 'C'. Use `[a-zA-Z]` to match both uppercase and lowercase characters.This is due to a known limitation in Lucene's regular expression engine.
  See [Lucene issue #14378](https://github.com/apache/lucene/issues/14378) for details.
</note>


## Optional operators

You can use the `flags` parameter to enable more optional operators for Lucene’s regular expression engine.
To enable multiple operators, use a `|` separator. For example, a `flags` value of `COMPLEMENT|INTERVAL` enables the `COMPLEMENT` and `INTERVAL` operators.

### Valid values

<definitions>
  <definition term="ALL (Default)">
    Enables all optional operators.
  </definition>
  <definition term=""" (empty string)">
    Alias for the `ALL` value.
  </definition>
  <definition term="COMPLEMENT">
    Enables the `~` operator. You can use `~` to negate the shortest following pattern. For example:
  </definition>
</definitions>

```
a~bc  
```

<definitions>
  <definition term="EMPTY">
    Enables the `#` (empty language) operator. The `#` operator doesn’t match any string, not even an empty string.
  </definition>
</definitions>

If you create regular expressions by programmatically combining values, you can pass `#` to specify "no string." This lets you avoid accidentally matching empty strings or other unwanted strings. For example:
```
#|abc 
```

<definitions>
  <definition term="INTERVAL">
    Enables the `<>` operators. You can use `<>` to match a numeric range. For example:
  </definition>
</definitions>

```
foo<1-100>     
foo<01-100>    
```

<definitions>
  <definition term="INTERSECTION">
    Enables the `&` operator, which acts as an AND operator. The match will succeed if patterns on both the left side AND the right side matches. For example:
  </definition>
</definitions>

```
aaa.+&.+bbb 
```

<definitions>
  <definition term="ANYSTRING">
    Enables the `@` operator. You can use `@` to match any entire string.
  </definition>
</definitions>

You can combine the `@` operator with `&` and `~` operators to create an "everything except" logic. For example:
```
@&~(abc.+) 
```

<definitions>
  <definition term="NONE">
    Disables all optional operators.
  </definition>
</definitions>


## Unsupported operators

Lucene’s regular expression engine does not support anchor operators, such as `^` (beginning of line) or `$` (end of line). To match a term, the regular expression must match the entire string.