﻿---
title: Text expansion query
description: The text expansion query uses a natural language processing model to convert the query text into a list of token-weight pairs which are then used in a...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-text-expansion-query
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Deprecated
  - Elastic Stack: Deprecated since 8.15
---

# Text expansion query
<warning>
  This query has been replaced by [Sparse vector](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-sparse-vector-query).
</warning>

<admonition title="Deprecation usage note">
  You can continue using `rank_features` fields with `text_expansion` queries in the current version. However, if you plan to upgrade, we recommend updating mappings to use the `sparse_vector` field type and [reindexing your data](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex). This will allow you to take advantage of the new capabilities and improvements available in newer versions.
</admonition>

The text expansion query uses a natural language processing model to convert the query text into a list of token-weight pairs which are then used in a query against a [sparse vector](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/sparse-vector) or [rank features](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/rank-features) field.

## Example request

```json

{
   "query":{
      "text_expansion":{
         "<sparse_vector_field>":{
            "model_id":"the model to produce the token weights",
            "model_text":"the query string"
         }
      }
   }
}
```


## Top level parameters for `text_expansion`

<definitions>
  <definition term="<sparse_vector_field>">
    (Required, object) The name of the field that contains the token-weight pairs the NLP model created based on the input text.
  </definition>
</definitions>


## Top level parameters for `<sparse_vector_field>`

<definitions>
  <definition term="model_id">
    (Required, string) The ID of the model to use to convert the query text into token-weight pairs. It must be the same model ID that was used to create the tokens from the input text.
  </definition>
  <definition term="model_text">
    (Required, string) The query text you want to use for search.
  </definition>
  <definition term="pruning_config Elastic Stack: Preview Elastic Cloud Serverless: Preview">
    (Optional, object) Optional pruning configuration. If enabled, this will omit non-significant tokens from the query in order to improve query performance. Default: Disabled.
    Parameters for `<pruning_config>` are:
    <definitions>
      <definition term="tokens_freq_ratio_threshold">
        (Optional, integer) Tokens whose frequency is more than `tokens_freq_ratio_threshold` times the average frequency of all tokens in the specified field are considered outliers and pruned. This value must between 1 and 100. Default: `5`.
      </definition>
      <definition term="tokens_weight_threshold">
        (Optional, float) Tokens whose weight is less than `tokens_weight_threshold` are considered insignificant and pruned. This value must be between 0 and 1. Default: `0.4`.
      </definition>
      <definition term="only_score_pruned_tokens">
        (Optional, boolean) If `true` we only input pruned tokens into scoring, and discard non-pruned tokens. It is strongly recommended to set this to `false` for the main query, but this can be set to `true` for a rescore query to get more relevant results. Default: `false`.
      </definition>
    </definitions>
    <note>
      The default values for `tokens_freq_ratio_threshold` and `tokens_weight_threshold` were chosen based on tests using ELSER that provided the optimal results.
    </note>
  </definition>
</definitions>


## Example ELSER query

The following is an example of the `text_expansion` query that references the ELSER model to perform semantic search. For a more detailed description of how to perform semantic search by using ELSER and the `text_expansion` query, refer to [this tutorial](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-elser-ingest-pipelines).
```json

{
   "query":{
      "text_expansion":{
         "ml.tokens":{
            "model_id":".elser_model_2",
            "model_text":"How is the weather in Jamaica?"
         }
      }
   }
}
```

Multiple `text_expansion` queries can be combined with each other or other query types. This can be achieved by wrapping them in [boolean query clauses](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) and using linear boosting:
```json

{
  "query": {
    "bool": {
      "should": [
        {
          "text_expansion": {
            "ml.inference.title_expanded.predicted_value": {
              "model_id": ".elser_model_2",
              "model_text": "How is the weather in Jamaica?",
              "boost": 1
            }
          }
        },
        {
          "text_expansion": {
            "ml.inference.description_expanded.predicted_value": {
              "model_id": ".elser_model_2",
              "model_text": "How is the weather in Jamaica?",
              "boost": 1
            }
          }
        },
        {
          "multi_match": {
            "query": "How is the weather in Jamaica?",
            "fields": [
              "title",
              "description"
            ],
            "boost": 4
          }
        }
      ]
    }
  }
}
```

This can also be achieved using [reciprocal rank fusion (RRF)](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/reciprocal-rank-fusion), through an [`rrf` retriever](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rrf-retriever) with multiple [`standard` retrievers](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/standard-retriever).
```json

{
  "retriever": {
    "rrf": {
      "retrievers": [
        {
          "standard": {
            "query": {
              "multi_match": {
                "query": "How is the weather in Jamaica?",
                "fields": [
                  "title",
                  "description"
                ]
              }
            }
          }
        },
        {
          "standard": {
            "query": {
              "text_expansion": {
                "ml.inference.title_expanded.predicted_value": {
                  "model_id": ".elser_model_2",
                  "model_text": "How is the weather in Jamaica?"
                }
              }
            }
          }
        },
        {
          "standard": {
            "query": {
              "text_expansion": {
                "ml.inference.description_expanded.predicted_value": {
                  "model_id": ".elser_model_2",
                  "model_text": "How is the weather in Jamaica?"
                }
              }
            }
          }
        }
      ],
      "window_size": 10,
      "rank_constant": 20
    }
  }
}
```


## Example ELSER query with pruning configuration and rescore

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview
</applies-to>

The following is an extension to the previous example that adds a pruning configuration  to the `text_expansion` query. The pruning configuration identifies non-significant tokens to prune from the query in order to improve query performance.
Token pruning happens at the shard level. While this should result in the same tokens being labeled as insignificant across shards, this is not guaranteed based on the composition of each shard. Therefore, if you are running `text_expansion` with a `pruning_config` on a multi-shard index, we strongly recommend adding a [Rescore filtered search results](/docs/reference/elasticsearch/rest-apis/rescore-search-results#rescore) function with the tokens that were originally pruned from the query. This will help mitigate any shard-level inconsistency with pruned tokens and provide better relevance overall.
```json

{
   "query":{
      "text_expansion":{
         "ml.tokens":{
            "model_id":".elser_model_2",
            "model_text":"How is the weather in Jamaica?",
            "pruning_config": {
               "tokens_freq_ratio_threshold": 5,
               "tokens_weight_threshold": 0.4,
               "only_score_pruned_tokens": false
           }
         }
      }
   },
   "rescore": {
      "window_size": 100,
      "query": {
         "rescore_query": {
            "text_expansion": {
               "ml.tokens": {
                  "model_id": ".elser_model_2",
                  "model_text": "How is the weather in Jamaica?",
                  "pruning_config": {
                     "tokens_freq_ratio_threshold": 5,
                     "tokens_weight_threshold": 0.4,
                     "only_score_pruned_tokens": true
                  }
               }
            }
         }
      }
   }
}
```

<note>
  Depending on your data, the text expansion query may be faster with `track_total_hits: false`.
</note>