﻿---
title: Span within query
description: Returns matches which are enclosed inside another span query. Here is an example: The big and little clauses can be any span type query. Matching spans...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-span-within-query
products:
  - Elasticsearch
---

# Span within query
Returns matches which are enclosed inside another span query. Here is an example:
```json

{
  "query": {
    "span_within": {
      "little": {
        "span_term": { "field1": "foo" }
      },
      "big": {
        "span_near": {
          "clauses": [
            { "span_term": { "field1": "bar" } },
            { "span_term": { "field1": "baz" } }
          ],
          "slop": 5,
          "in_order": true
        }
      }
    }
  }
}
```

The `big` and `little` clauses can be any span type query. Matching spans from `little` that are enclosed within `big` are returned.