﻿---
title: Span term query
description: Matches spans containing a term. Here is an example: A boost can also be associated with the query: Or : 
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-span-term-query
products:
  - Elasticsearch
---

# Span term query
Matches spans containing a term. Here is an example:
```json

{
  "query": {
    "span_term" : { "user.id" : "kimchy" }
  }
}
```

A boost can also be associated with the query:
```json

{
  "query": {
    "span_term" : { "user.id" : { "value" : "kimchy", "boost" : 2.0 } }
  }
}
```

Or :
```json

{
  "query": {
    "span_term" : { "user.id" : { "term" : "kimchy", "boost" : 2.0 } }
  }
}
```