﻿---
title: Span near query
description: Matches spans which are near one another. One can specify slop, the maximum number of intervening unmatched positions, as well as whether matches are...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-span-near-query
products:
  - Elasticsearch
---

# Span near query
Matches spans which are near one another. One can specify *slop*, the maximum number of intervening unmatched positions, as well as whether matches are required to be in-order. Here is an example:
```json

{
  "query": {
    "span_near": {
      "clauses": [
        { "span_term": { "field": "value1" } },
        { "span_term": { "field": "value2" } },
        { "span_term": { "field": "value3" } }
      ],
      "slop": 12,
      "in_order": false
    }
  }
}
```

The `clauses` element is a list of one or more other span type queries and the `slop` controls the maximum number of intervening unmatched positions permitted.