﻿---
title: Span first query
description: Matches spans near the beginning of a field. Here is an example: The match clause can be any other span type query. The end controls the maximum end position...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-span-first-query
products:
  - Elasticsearch
---

# Span first query
Matches spans near the beginning of a field. Here is an example:
```json

{
  "query": {
    "span_first": {
      "match": {
        "span_term": { "user.id": "kimchy" }
      },
      "end": 3
    }
  }
}
```

The `match` clause can be any other span type query. The `end` controls the maximum end position permitted in a match.