﻿---
title: Span containing query
description: Returns matches which enclose another span query. Here is an example: The big and little clauses can be any span type query. Matching spans from big that...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-span-containing-query
products:
  - Elasticsearch
---

# Span containing query
Returns matches which enclose another span query. Here is an example:
```json

{
  "query": {
    "span_containing": {
      "little": {
        "span_term": { "field1": "foo" }
      },
      "big": {
        "span_near": {
          "clauses": [
            { "span_term": { "field1": "bar" } },
            { "span_term": { "field1": "baz" } }
          ],
          "slop": 5,
          "in_order": true
        }
      }
    }
  }
}
```

The `big` and `little` clauses can be any span type query. Matching spans from `big` that contain matches from `little` are returned.