﻿---
title: Semantic query
description: The semantic query type enables you to perform semantic search on data stored in a semantic_text field. This query accepts natural-language text and uses...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-semantic-query
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Semantic query
<note>
  We don't recommend this legacy query type for _new_ projects. Use the match query (with [QueryDSL](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query) or [ESQL](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-match)) instead. The semantic query remains available to support existing implementations.
</note>

The `semantic` query type enables you to perform [semantic search](https://www.elastic.co/docs/solutions/search/semantic-search) on data stored in a [`semantic_text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text) field. This query accepts natural-language text and uses the field’s configured inference endpoint to generate a query embedding and match documents.
For an overview of all query options available for `semantic_text` fields, see [Querying `semantic_text` fields](/docs/reference/elasticsearch/mapping-reference/semantic-text-search-retrieval#querying-semantic-text-fields).

## Inference endpoint selection

The target field of `semantic` query must be mapped as `semantic_text` and associated with an inference endpoint. At query time, the inference endpoint is chosen as follows:
- If `search_inference_id` is defined, the semantic query uses that endpoint to embed the query.
- If no `search_inference_id` is defined, `inference_id` is used for both indexing and search.
- If no endpoint is specified at mapping, `inference_id` defaults to `.elser-2-elasticsearch`.￼

The underlying vector type (dense or sparse) is determined by the endpoint automatically. No extra query parameters are required.

## Example request

```json

{
  "query": {
    "semantic": {
      "field": "inference_field",
      "query": "Best surfing places"
    }
  }
}
```


## Top-level parameters for `semantic`

<definitions>
  <definition term="field">
    (Required, string) The `semantic_text` field to perform the query on.
  </definition>
  <definition term="query">
    (Required, string) The query text to be searched for on the field.
  </definition>
</definitions>

Refer to [this tutorial](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text) to learn more about semantic search using `semantic_text` and `semantic` query.

## Hybrid search with the `semantic` query

The `semantic` query can be used as a part of a hybrid search where the `semantic` query is combined with lexical queries. For example, the query below finds documents with the `title` field matching "mountain lake", and combines them with results from a semantic search on the field `title_semantic`, that is a `semantic_text` field. The combined documents are then scored, and the top 3 top scored documents are returned.
```json

{
  "size" : 3,
  "query": {
    "bool": {
      "should": [
        {
          "match": {
            "title": {
              "query": "mountain lake",
              "boost": 1
            }
          }
        },
        {
          "semantic": {
            "field": "title_semantic",
            "query": "mountain lake",
            "boost": 2
          }
        }
      ]
    }
  }
}
```

You can also use semantic_text as part of [Reciprocal Rank Fusion](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/reciprocal-rank-fusion) to make ranking relevant results easier:
```json

{
  "retriever": {
    "rrf": {
      "retrievers": [
        {
          "standard": {
            "query": {
              "term": {
                "text": "shoes"
              }
            }
          }
        },
        {
          "standard": {
            "query": {
              "semantic": {
                "field": "semantic_field",
                "query": "shoes"
              }
            }
          }
        }
      ],
      "rank_window_size": 50,
      "rank_constant": 20
    }
  }
}
```