﻿---
title: Script query
description: Filters documents based on a provided script. The script query is typically used in a filter context. You can achieve the same results in a search query...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-script-query
products:
  - Elasticsearch
---

# Script query
<note>
  [Runtime fields](https://www.elastic.co/docs/manage-data/data-store/mapping/runtime-fields) provide a very similar feature that is more flexible. You write a script to create field values and they are available everywhere, such as [`fields`](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields), [all queries](https://www.elastic.co/docs/reference/query-languages/querydsl), and [aggregations](https://www.elastic.co/docs/reference/aggregations).
</note>

Filters documents based on a provided [script](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-using). The `script` query is typically used in a [filter context](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-filter-context).
<warning>
  Using scripts can result in slower search speeds. See [Scripts, caching, and search speed](https://www.elastic.co/docs/explore-analyze/scripting/scripts-search-speed).
</warning>


## Example request

```json

{
  "query": {
    "bool": {
      "filter": {
        "script": {
          "script": """
            double amount = doc['amount'].value;
            if (doc['type'].value == 'expense') {
              amount *= -1;
            }
            return amount < 10;
          """
        }
      }
    }
  }
}
```

You can achieve the same results in a search query by using runtime fields. Use the [`fields`](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields) parameter on the `_search` API to fetch values as part of the same query:
```json

{
  "runtime_mappings": {
    "amount.signed": {
      "type": "double",
      "script": """
        double amount = doc['amount'].value;
        if (doc['type'].value == 'expense') {
          amount *= -1;
        }
        emit(amount);
      """
    }
  },
  "query": {
    "bool": {
      "filter": {
        "range": {
          "amount.signed": { "lt": 10 }
        }
      }
    }
  },
  "fields": [{"field": "amount.signed"}]
}
```


## Top-level parameters for `script`

<definitions>
  <definition term="script">
    (Required, [script object](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-using)) Contains a script to run as a query. This script must return a boolean value, `true` or `false`.
  </definition>
</definitions>


## Notes


### Custom parameters

Like [filters](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-filter-context), scripts are cached for faster execution. If you frequently change the arguments of a script, we recommend you store them in the script’s `params` parameter. For example:
```json

{
  "query": {
    "bool": {
      "filter": {
        "script": {
          "script": {
            "source": "doc['num1'].value > params.param1",
            "lang": "painless",
            "params": {
              "param1": 5
            }
          }
        }
      }
    }
  }
}
```


### Allow expensive queries

Script queries will not be executed if [`search.allow_expensive_queries`](/docs/reference/query-languages/querydsl#query-dsl-allow-expensive-queries) is set to false.