﻿---
title: Range query
description: Returns documents that contain terms within a provided range. The following search returns documents where the age field contains a term between 10 and...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-range-query
products:
  - Elasticsearch
---

# Range query
Returns documents that contain terms within a provided range.

## Example request

The following search returns documents where the `age` field contains a term between `10` and `20`.
```json

{
  "query": {
    "range": {
      "age": {
        "gte": 10,
        "lte": 20,
        "boost": 2.0
      }
    }
  }
}
```


## Top-level parameters for `range`

<definitions>
  <definition term="<field>">
    (Required, object) Field you wish to search.
  </definition>
</definitions>


## Parameters for `<field>`

<definitions>
  <definition term="gt">
    (Optional) Greater than.
  </definition>
  <definition term="gte">
    (Optional) Greater than or equal to.
  </definition>
  <definition term="lt">
    (Optional) Less than.
  </definition>
  <definition term="lte">
    (Optional) Less than or equal to.
  </definition>
  <definition term="format">
    (Optional, string) Date format used to convert `date` values in the query.
    By default, Elasticsearch uses the [date `format`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-date-format) provided in the `<field>`'s
    mapping. This value overrides that mapping format.
    For valid syntax, see [`format`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-date-format).
  </definition>
</definitions>

<warning>
  If a format or date value is incomplete, the range query replaces any missing components with default values. See [Missing date components](#missing-date-components).
</warning>


<definitions>
  <definition term="relation">
    (Optional, string) Indicates how the range query matches values for `range`
    fields. Valid values are:
    <definitions>
      <definition term="INTERSECTS (Default)">
        Matches documents with a range field value that intersects the query’s range.
      </definition>
      <definition term="CONTAINS">
        Matches documents with a range field value that entirely contains the query’s range.
      </definition>
      <definition term="WITHIN">
        Matches documents with a range field value entirely within the query’s range.
      </definition>
    </definitions>
  </definition>
  <definition term="time_zone">
    (Optional, string) [Coordinated Universal Time (UTC) offset](https://en.wikipedia.org/wiki/List_of_UTC_time_offsets) or [IANA time zone](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones)
    used to convert `date` values in the query to UTC.
    Valid values are ISO 8601 UTC offsets, such as `+01:00` or -`08:00`, and IANA
    time zone IDs, such as `America/Los_Angeles`.
    For an example query using the `time_zone` parameter, see
    [Time zone in `range` queries](#range-query-time-zone).
  </definition>
</definitions>

<note>
  The `time_zone` parameter does **not** affect the [date math](/docs/reference/elasticsearch/rest-apis/common-options#date-math) value of `now`. `now` is always the current system time in UTC.However, the `time_zone` parameter does convert dates calculated using `now` and [date math rounding](/docs/reference/elasticsearch/rest-apis/common-options#date-math). For example, the `time_zone` parameter will convert a value of `now/d`.
</note>

<definitions>
  <definition term="boost">
    (Optional, float) Floating point number used to decrease or increase the
    [relevance scores](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) of a query. Defaults to `1.0`.
    You can use the `boost` parameter to adjust relevance scores for searches
    containing two or more queries.
    Boost values are relative to the default value of `1.0`. A boost value between `0`
    and `1.0` decreases the relevance score. A value greater than `1.0`
    increases the relevance score.
  </definition>
</definitions>


## Notes


### Using the `range` query with `text` and `keyword` fields

Range queries on [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) or [`keyword`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword) fields will not be executed if [`search.allow_expensive_queries`](/docs/reference/query-languages/querydsl#query-dsl-allow-expensive-queries) is set to false.

### Using the `range` query with `date` fields

When the `<field>` parameter is a [`date`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date) field data type, you can use [date math](/docs/reference/elasticsearch/rest-apis/common-options#date-math) with the following parameters:
- `gt`
- `gte`
- `lt`
- `lte`

For example, the following search returns documents where the `timestamp` field contains a date between today and yesterday.
```json

{
  "query": {
    "range": {
      "timestamp": {
        "gte": "now-1d/d",
        "lte": "now/d"
      }
    }
  }
}
```


#### Missing date components

For range queries and [date range](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-daterange-aggregation) aggregations, Elasticsearch replaces missing date components with the following values. Missing year components are not replaced.
```text
MONTH_OF_YEAR:    01
DAY_OF_MONTH:     01
HOUR_OF_DAY:      23
MINUTE_OF_HOUR:   59
SECOND_OF_MINUTE: 59
NANO_OF_SECOND:   999_999_999
```

For example, if the format is `yyyy-MM`, Elasticsearch converts a `gt` value of `2099-12` to `2099-12-01T23:59:59.999_999_999Z`. This date uses the provided year (`2099`) and month (`12`) but uses the default day (`01`), hour (`23`), minute (`59`), second (`59`), and nanosecond (`999_999_999`).

#### Numeric date range value

When no date format is specified and the range query is targeting a date field, numeric values are interpreted representing milliseconds-since-the-epoch. If you want the value to represent a year, e.g. 2020, you need to pass it as a String value (e.g. "2020") that will be parsed according to the default format or the set format.

#### Date math and rounding

Elasticsearch rounds [date math](/docs/reference/elasticsearch/rest-apis/common-options#date-math) values in parameters as follows:
<definitions>
  <definition term="gt">
    Rounds up to the first millisecond not covered by the rounded date.
    For example, `2014-11-18||/M` rounds up to `2014-12-01T00:00:00.000`,
    excluding the entire month of November.
  </definition>
  <definition term="gte">
    Rounds down to the first millisecond.
    For example, `2014-11-18||/M` rounds down to `2014-11-01T00:00:00.000`,
    including the entire month.
  </definition>
  <definition term="lt">
    Rounds down to the last millisecond before the rounded value.
    For example, `2014-11-18||/M` rounds down to `2014-10-31T23:59:59.999`,
    excluding the entire month of November.
  </definition>
  <definition term="lte">
    Rounds up to the latest millisecond in the rounding interval.
    For example, `2014-11-18||/M` rounds up to `2014-11-30T23:59:59.999`,
    including the entire month.
  </definition>
</definitions>


### Example query using `time_zone` parameter

You can use the `time_zone` parameter to convert `date` values to UTC using a UTC offset. For example:
```json

{
  "query": {
    "range": {
      "timestamp": {
        "time_zone": "+01:00",        <1>
        "gte": "2020-01-01T00:00:00", <2>
        "lte": "now"                  <3>
      }
    }
  }
}
```