﻿---
title: Prefix query
description: Returns documents that contain a specific prefix in a provided field. The following search returns documents where the user.id field contains a term that...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-prefix-query
products:
  - Elasticsearch
---

# Prefix query
Returns documents that contain a specific prefix in a provided field.

## Example request

The following search returns documents where the `user.id` field contains a term that begins with `ki`.
```json

{
  "query": {
    "prefix": {
      "user.id": {
        "value": "ki"
      }
    }
  }
}
```


## Top-level parameters for `prefix`

<definitions>
  <definition term="<field>">
    (Required, object) Field you wish to search.
  </definition>
</definitions>


## Parameters for `<field>`

<definitions>
  <definition term="value">
    (Required, string) Beginning characters of terms you wish to find in the provided `<field>`.
  </definition>
  <definition term="rewrite">
    (Optional, string) Method used to rewrite the query. For valid values and more information, see the [`rewrite` parameter](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-multi-term-rewrite).
  </definition>
  <definition term="case_insensitive">
    <admonition title="Added in 7.10.0">
      This parameter was added in 7.10.0.
    </admonition>
    (Optional, Boolean) Allows ASCII case insensitive matching of the value with the indexed field values when set to true. Default is false which means the case sensitivity of matching depends on the underlying field’s mapping.
  </definition>
</definitions>


## Notes


### Short request example

You can simplify the `prefix` query syntax by combining the `<field>` and `value` parameters. For example:
```json

{
  "query": {
    "prefix" : { "user" : "ki" }
  }
}
```


### Speed up prefix queries

You can speed up prefix queries using the [`index_prefixes`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-prefixes) mapping parameter. If enabled, Elasticsearch indexes prefixes in a separate field, according to the configuration settings. This lets Elasticsearch run prefix queries more efficiently at the cost of a larger index.

### Allow expensive queries

Prefix queries will not be executed if [`search.allow_expensive_queries`](/docs/reference/query-languages/querydsl#query-dsl-allow-expensive-queries) is set to false. However, if [`index_prefixes`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-prefixes) are enabled, an optimised query is built which is not considered slow, and will be executed in spite of this setting.