﻿---
title: Pinned query
description: Promotes selected documents to rank higher than those matching a given query. This feature is typically used to guide searchers to curated documents that...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-pinned-query
products:
  - Elasticsearch
---

# Pinned query
Promotes selected documents to rank higher than those matching a given query. This feature is typically used to guide searchers to curated documents that are promoted over and above any "organic" matches for a search. The promoted or "pinned" documents are identified using the document IDs stored in the [`_id`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-id-field) field.
<note>
  Pinned queries are designed to work only with relevance-based sorting. Using explicit `sort` criteria overrides the pinned document promotion.
</note>


## Example request

```json

{
  "query": {
    "pinned": {
      "ids": [ "1", "4", "100" ],
      "organic": {
        "match": {
          "description": "iphone"
        }
      }
    }
  }
}
```


## Top-level parameters for `pinned`

<definitions>
  <definition term="ids">
    (Optional, array) [Document IDs](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-id-field) listed in the order they are to appear in results. Required if `docs` is not specified.
  </definition>
  <definition term="docs">
    (Optional, array) Documents listed in the order they are to appear in results. Required if `ids` is not specified. You can specify the following attributes for each document:
    <definitions>
      <definition term="_id">
        (Required, string) The unique [document ID](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-id-field).
      </definition>
      <definition term="_index">
        (Optional, string) The index that contains the document.
      </definition>
    </definitions>
  </definition>
  <definition term="organic">
    Any choice of query used to rank documents which will be ranked below the "pinned" documents.
  </definition>
</definitions>


## Pin documents in a specific index

If you’re searching over multiple indices, you can pin a document within a specific index using `docs`:
```json

{
  "query": {
    "pinned": {
      "docs": [
        {
          "_index": "my-index-000001", <1>
          "_id": "1"
        },
        {
          "_id": "4" <2>
        }
      ],
      "organic": {
        "match": {
          "description": "iphone"
        }
      }
    }
  }
}
```