﻿---
title: Parent ID query
description: Returns child documents joined to a specific parent document. You can use a join field mapping to create parent-child relationships between documents...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-parent-id-query
products:
  - Elasticsearch
---

# Parent ID query
Returns child documents [joined](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/parent-join) to a specific parent document. You can use a [join](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/parent-join) field mapping to create parent-child relationships between documents in the same index.

## Example request


### Index setup

To use the `parent_id` query, your index must include a [join](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/parent-join) field mapping. To see how you can set up an index for the `parent_id` query, try the following example.
1. Create an index with a [join](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/parent-join) field mapping.
   ```json

   {
     "mappings": {
       "properties": {
         "my-join-field": {
           "type": "join",
           "relations": {
             "my-parent": "my-child"
           }
         }
       }
     }
   }
   ```
   
2. Index a parent document with an ID of `1`.
   ```json

   {
     "text": "This is a parent document.",
     "my-join-field": "my-parent"
   }
   ```
3. Index a child document of the parent document.
   ```json

   {
     "text": "This is a child document.",
     "my-join-field": {
       "name": "my-child",
       "parent": "1"
     }
   }
   ```


### Example query

The following search returns child documents for a parent document with an ID of `1`.
```json

{
  "query": {
      "parent_id": {
          "type": "my-child",
          "id": "1"
      }
  }
}
```


## Top-level parameters for `parent_id`

<definitions>
  <definition term="type">
    (Required, string) Name of the child relationship mapped for the [join](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/parent-join) field.
  </definition>
  <definition term="id">
    (Required, string) ID of the parent document. The query will return child documents of this parent document.
  </definition>
  <definition term="ignore_unmapped">
    (Optional, Boolean) Indicates whether to ignore an unmapped `type` and not return any documents instead of an error. Defaults to `false`.
  </definition>
</definitions>

If `false`, Elasticsearch returns an error if the `type` is unmapped.
You can use this parameter to query multiple indices that may not contain the `type`.