﻿---
title: Match phrase query
description: The match_phrase query analyzes the text and creates a phrase query out of the analyzed text. For example: A phrase query matches terms up to a configurable...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query-phrase
products:
  - Elasticsearch
---

# Match phrase query
The `match_phrase` query analyzes the text and creates a `phrase` query out of the analyzed text. For example:
```json

{
  "query": {
    "match_phrase": {
      "message": "this is a test"
    }
  }
}
```


## Parameters for `<field>`

<definitions>
  <definition term="query">
    (Required) Text, number, boolean value or date you wish to find in the provided `<field>`.
  </definition>
  <definition term="analyzer">
    (Optional, string) [Analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis) used to convert the text in the `query` value into tokens. Defaults to the [index-time analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis/specify-an-analyzer#specify-index-time-analyzer) mapped for the `<field>`. If no analyzer is mapped, the index’s default analyzer is used.
  </definition>
  <definition term="boost">
    (Optional, float) Floating point number used to decrease or increase the [relevance scores](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) of the query. Defaults to `1.0`.
    Boost values are relative to the default value of `1.0`. A boost value between `0` and `1.0` decreases the relevance score. A value greater than `1.0` increases the relevance score.
  </definition>
  <definition term="slop">
    (Optional, integer) Maximum number of positions allowed between matching tokens. Defaults to `0`. Transposed terms have a slop of `2`.
  </definition>
  <definition term="zero_terms_query">
    (Optional, string) Indicates whether no documents are returned if the `analyzer` removes all tokens, such as when using a `stop` filter. Valid values are:
    - `none` (Default)
      No documents are returned if the `analyzer` removes all tokens.
    - `all`
      Returns all documents, similar to a [`match_all`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-all-query) query.
  </definition>
</definitions>

A phrase query matches terms up to a configurable `slop` (which defaults to 0) in any order. Transposed terms have a slop of 2.

### Analyzer in the match phrase query

The `analyzer` can be set to control which analyzer will perform the analysis process on the text. It defaults to the field explicit mapping definition, or the default search analyzer, for example:
```json

{
  "query": {
    "match_phrase": {
      "message": {
        "query": "this is a test",
        "analyzer": "my_analyzer"
      }
    }
  }
}
```