﻿---
title: Match boolean prefix query
description: A match_bool_prefix query analyzes its input and constructs a bool query from the terms. Each term except the last is used in a term query. The last term...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-bool-prefix-query
products:
  - Elasticsearch
---

# Match boolean prefix query
A `match_bool_prefix` query analyzes its input and constructs a [`bool` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) from the terms. Each term except the last is used in a `term` query. The last term is used in a `prefix` query. A `match_bool_prefix` query such as
```json

{
  "query": {
    "match_bool_prefix" : {
      "message" : "quick brown f"
    }
  }
}
```

where analysis produces the terms `quick`, `brown`, and `f` is similar to the following `bool` query
```json

{
  "query": {
    "bool" : {
      "should": [
        { "term": { "message": "quick" }},
        { "term": { "message": "brown" }},
        { "prefix": { "message": "f"}}
      ]
    }
  }
}
```

An important difference between the `match_bool_prefix` query and [`match_phrase_prefix`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query-phrase-prefix) is that the `match_phrase_prefix` query matches its terms as a phrase, but the `match_bool_prefix` query can match its terms in any position. The example `match_bool_prefix` query above could match a field containing `quick brown fox`, but it could also match `brown fox quick`. It could also match a field containing the term `quick`, the term `brown` and a term starting with `f`, appearing in any position.

## Parameters

By default, `match_bool_prefix` queries' input text will be analyzed using the analyzer from the queried field’s mapping. A different search analyzer can be configured with the `analyzer` parameter
```json

{
  "query": {
    "match_bool_prefix": {
      "message": {
        "query": "quick brown f",
        "analyzer": "keyword"
      }
    }
  }
}
```

`match_bool_prefix` queries support the [`minimum_should_match`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-minimum-should-match) and `operator` parameters as described for the [`match` query](/docs/reference/query-languages/query-dsl/query-dsl-match-query#query-dsl-match-query-boolean), applying the setting to the constructed `bool` query. The number of clauses in the constructed `bool` query will in most cases be the number of terms produced by analysis of the query text.
The [`fuzziness`](/docs/reference/query-languages/query-dsl/query-dsl-match-query#query-dsl-match-query-fuzziness), `prefix_length`, `max_expansions`, `fuzzy_transpositions`, and `fuzzy_rewrite` parameters can be applied to the `term` subqueries constructed for all terms but the final term. They do not have any effect on the prefix query constructed for the final term.