﻿---
title: KQL query
description: Returns documents matching a provided KQL expression. The value of the query parameter is parsed using the Kibana Query Language (KQL) and rewritten into...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-kql-query
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1, Preview in 9.0
---

# KQL query
Returns documents matching a provided KQL expression. The value of the `query` parameter is parsed using the
[Kibana Query Language (KQL)](https://www.elastic.co/docs/reference/query-languages/kql) and rewritten
into standard Query DSL.
Use this query when you want to accept KQL input (for example from a Kibana search bar) directly in Elasticsearch.

## Example request

The following example returns documents where `service.name` is `"checkout-service"` and `http.response.status_code` is `200`.
```json

{
  "query": {
    "kql": {
      "query": "service.name: \"checkout-service\" AND http.response.status_code: 200"
    }
  }
}
```


## Top-level parameters for `kql`

<definitions>
  <definition term="query">
    (Required, string) The KQL expression to parse. See the
    [KQL language reference](https://www.elastic.co/docs/reference/query-languages/kql) for supported
    syntax.
  </definition>
  <definition term="case_insensitive">
    (Optional, boolean) If `true`, performs case-insensitive matching for field names and keyword / text terms.
    Defaults to `false`.
  </definition>
  <definition term="default_field">
    (Optional, string) Default field (or field pattern with wildcards) to target when a bare term in the query
    string does not specify a field. Supports wildcards (`*`).
    Defaults to the [`index.query.default_field`](/docs/reference/elasticsearch/index-settings/index-modules#index-query-default-field)
    index setting (default value is `*`). The value `*` expands to all fields that are eligible for term queries
    (metadata fields excluded). Searching *all* eligible fields can be expensive on mappings with many fields and
    is subject to the `indices.query.bool.max_clause_count` limit.
    Like other queries, this implicit expansion does not traverse [nested](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/nested)
    documents.
  </definition>
  <definition term="time_zone">
    (Optional, string) [UTC offset](https://en.wikipedia.org/wiki/List_of_UTC_time_offsets) or
    [IANA time zone](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones) used to interpret date literals
    (for example `@timestamp > now-2d`). Does not change the value of `now` (which is always system UTC) but affects
    rounding and the interpretation of explicit date strings.
  </definition>
  <definition term="boost">
    (Optional, float) Standard query *boost*. Defaults to `1.0`.
  </definition>
  <definition term="_name">
    (Optional, string) A name to identify this query in the response's `matched_queries`.
  </definition>
</definitions>


## Syntax reference

The `kql` query accepts a single KQL expression string in the `query` parameter. All language elements (field matching,
wildcards, boolean logic, ranges, nested scoping) are defined in the
[KQL language reference](https://www.elastic.co/docs/reference/query-languages/kql). This page does not
duplicate that syntax.

## Additional examples


### Case-insensitive matching (log level)

```json

{
  "query": {
    "kql": {
      "query": "log.level: ErRoR",
      "case_insensitive": true
    }
  }
}
```


### Using a default field pattern

Search any field under the `logs` object for the term `timeout`:
```json

{
  "query": {
    "kql": {
      "query": "timeout",
      "default_field": "logs.*"
    }
  }
}
```


### Date range with time zone

```json

{
  "query": {
    "kql": {
      "query": "@timestamp >= ""2025-10-01"" AND @timestamp < ""2025-10-02""",
      "time_zone": "Europe/Paris"
    }
  }
}
```


### Nested field query

```json

{
  "query": {
    "kql": {
      "query": "events.stack:{ file: \"app.js\" AND line: 42 }"
    }
  }
}
```


## When to use `kql` vs `query_string`

Use `kql` for user-facing search boxes where you want a concise, filter-oriented syntax and to avoid Lucene’s
advanced operators (fuzzy, regexp, proximity, inline boosting). Use [`query_string`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-query-string-query)
or [`simple_query_string`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-simple-query-string-query) when those advanced features are required.

## Notes and limitations

- The parsed KQL expression is rewritten into standard Query DSL and participates in scoring unless wrapped in a
  filter context (for example inside a `bool.filter`). Adjust relevance with `boost` if needed.
- Large wildcard expansions (in field names or terms) can hit the `indices.query.bool.max_clause_count` safeguard.
- Nested documents require the KQL nested syntax (`path:{ ... }`); terms are not correlated across separate nested
  objects automatically.
- Unsupported syntax (such as fuzzy operators) results in a parse error.


## See also

- [KQL language reference](https://www.elastic.co/docs/reference/query-languages/kql)
- [Default field setting](/docs/reference/elasticsearch/index-settings/index-modules#index-query-default-field)