﻿---
title: Geo-polygon query
description: A query returning hits that only fall within a polygon of points. Here is an example: Format as [lon, lat] Note: the order of lon/lat here must conform...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-geo-polygon-query
products:
  - Elasticsearch
---

# Geo-polygon query
<admonition title="Deprecated in 7.12.">
  Use [Geoshape](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-geo-shape-query) instead where polygons are defined in GeoJSON or [Well-Known Text (WKT)](http://docs.opengeospatial.org/is/18-010r7/18-010r7.html).
</admonition>

A query returning hits that only fall within a polygon of points. Here is an example:
```json

{
  "query": {
    "bool": {
      "must": {
        "match_all": {}
      },
      "filter": {
        "geo_polygon": {
          "person.location": {
            "points": [
              { "lat": 40, "lon": -70 },
              { "lat": 30, "lon": -80 },
              { "lat": 20, "lon": -90 }
            ]
          }
        }
      }
    }
  }
}
```


## Query options


| Option              | Description                                                                                                                                                                  |
|---------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `_name`             | Optional name field to identify the filter                                                                                                                                   |
| `validation_method` | Set to `IGNORE_MALFORMED` to accept geo points withinvalid latitude or longitude, `COERCE` to try and infer correct latitudeor longitude, or `STRICT` (default is `STRICT`). |


## Allowed formats


### Lat long as array

Format as `[lon, lat]`
Note: the order of lon/lat here must conform with [GeoJSON](http://geojson.org/).
```json

{
  "query": {
    "bool": {
      "must": {
        "match_all": {}
      },
      "filter": {
        "geo_polygon": {
          "person.location": {
            "points": [
              [ -70, 40 ],
              [ -80, 30 ],
              [ -90, 20 ]
            ]
          }
        }
      }
    }
  }
}
```


### Lat lon as string

Format in `lat,lon`.
```json

{
  "query": {
    "bool": {
      "must": {
        "match_all": {}
      },
      "filter": {
        "geo_polygon": {
          "person.location": {
            "points": [
              "40, -70",
              "30, -80",
              "20, -90"
            ]
          }
        }
      }
    }
  }
}
```


### Geohash

```json

{
  "query": {
    "bool": {
      "must": {
        "match_all": {}
      },
      "filter": {
        "geo_polygon": {
          "person.location": {
            "points": [
              "drn5x1g8cu2y",
              "30, -80",
              "20, -90"
            ]
          }
        }
      }
    }
  }
}
```


## `geo_point` type

The query **requires** the [`geo_point`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) type to be set on the relevant field.

## Ignore unmapped

When set to `true` the `ignore_unmapped` option will ignore an unmapped field and will not match any documents for this query. This can be useful when querying multiple indexes which might have different mappings. When set to `false` (the default value) the query will throw an exception if the field is not mapped.