﻿---
title: Geo-grid query
description: Matches geo_point and geo_shape values that intersect a grid cell from a GeoGrid aggregation. The query is designed to match the documents that fall inside...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-geo-grid-query
products:
  - Elasticsearch
---

# Geo-grid query
Matches [`geo_point`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) and [`geo_shape`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape) values that intersect a grid cell from a GeoGrid aggregation.
The query is designed to match the documents that fall inside a bucket of a geogrid aggregation by providing the key of the bucket. For geohash and geotile grids, the query can be used for geo_point and geo_shape fields. For geo_hex grid, it can only be used for geo_point fields.

### Example

Assume the following the following documents are indexed:
```json

{
  "mappings": {
    "properties": {
      "location": {
        "type": "geo_point"
      }
    }
  }
}


{
  "location" : "POINT(4.912350 52.374081)",
  "city": "Amsterdam",
  "name": "NEMO Science Museum"
}


{
  "location" : "POINT(4.405200 51.222900)",
  "city": "Antwerp",
  "name": "Letterenhuis"
}


{
  "location" : "POINT(2.336389 48.861111)",
  "city": "Paris",
  "name": "Musée du Louvre"
}
```


## geohash grid

Using a geohash_grid aggregation, it is possible to group documents depending on their geohash value:
```json

{
  "size" : 0,
  "aggs" : {
     "grouped" : {
        "geohash_grid" : {
           "field" : "location",
           "precision" : 2
        }
     }
  }
}
```

```json
{
  "took" : 10,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "skipped" : 0,
    "failed" : 0
  },
  "hits" : {
    "total" : {
      "value" : 3,
      "relation" : "eq"
    },
    "max_score" : null,
    "hits" : [ ]
  },
  "aggregations" : {
    "grouped" : {
      "buckets" : [
        {
          "key" : "u1",
          "doc_count" : 2
        },
        {
          "key" : "u0",
          "doc_count" : 1
        }
      ]
    }
  }
}
```

We can extract the documents on one of those buckets by executing a geo_grid query using the bucket key with the following syntax:
```json

{
  "query": {
    "geo_grid" :{
      "location" : {
        "geohash" : "u0"
      }
    }
  }
}
```

```json
{
  "took" : 1,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "skipped" : 0,
    "failed" : 0
  },
  "hits" : {
    "total" : {
      "value" : 1,
      "relation" : "eq"
    },
    "max_score" : 1.0,
    "hits" : [
      {
        "_index" : "my_locations",
        "_id" : "3",
        "_score" : 1.0,
        "_source" : {
          "location" : "POINT(2.336389 48.861111)",
          "city" : "Paris",
          "name" : "Musée du Louvre"
        }
      }
    ]
  }
}
```


## geotile grid

Using a geotile_grid aggregation, it is possible to group documents depending on their geotile value:
```json

{
  "size" : 0,
  "aggs" : {
     "grouped" : {
        "geotile_grid" : {
           "field" : "location",
           "precision" : 6
        }
     }
  }
}
```

```json
{
  "took" : 1,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "skipped" : 0,
    "failed" : 0
  },
  "hits" : {
    "total" : {
      "value" : 3,
      "relation" : "eq"
    },
    "max_score" : null,
    "hits" : [ ]
  },
  "aggregations" : {
    "grouped" : {
      "buckets" : [
        {
          "key" : "6/32/21",
          "doc_count" : 2
        },
        {
          "key" : "6/32/22",
          "doc_count" : 1
        }
      ]
    }
  }
}
```

We can extract the documents on one of those buckets by executing a geo_grid query using the bucket key with the following syntax:
```json

{
  "query": {
    "geo_grid" :{
      "location" : {
        "geotile" : "6/32/22"
      }
    }
  }
}
```

```json
{
  "took" : 1,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "skipped" : 0,
    "failed" : 0
  },
  "hits" : {
    "total" : {
      "value" : 1,
      "relation" : "eq"
    },
    "max_score" : 1.0,
    "hits" : [
      {
        "_index" : "my_locations",
        "_id" : "3",
        "_score" : 1.0,
        "_source" : {
          "location" : "POINT(2.336389 48.861111)",
          "city" : "Paris",
          "name" : "Musée du Louvre"
        }
      }
    ]
  }
}
```


## geohex grid

Using a geohex_grid aggregation, it is possible to group documents depending on their geohex value:
```json

{
  "size" : 0,
  "aggs" : {
     "grouped" : {
        "geohex_grid" : {
           "field" : "location",
           "precision" : 1
        }
     }
  }
}
```

```json
{
  "took" : 2,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "skipped" : 0,
    "failed" : 0
  },
  "hits" : {
    "total" : {
      "value" : 3,
      "relation" : "eq"
    },
    "max_score" : null,
    "hits" : [ ]
  },
  "aggregations" : {
    "grouped" : {
      "buckets" : [
        {
          "key" : "81197ffffffffff",
          "doc_count" : 2
        },
        {
          "key" : "811fbffffffffff",
          "doc_count" : 1
        }
      ]
    }
  }
}
```

We can extract the documents on one of those buckets by executing a geo_grid query using the bucket key with the following syntax:
```json

{
  "query": {
    "geo_grid" :{
      "location" : {
        "geohex" : "811fbffffffffff"
      }
    }
  }
}
```

```json
{
  "took" : 26,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "skipped" : 0,
    "failed" : 0
  },
  "hits" : {
    "total" : {
      "value" : 1,
      "relation" : "eq"
    },
    "max_score" : 1.0,
    "hits" : [
      {
        "_index" : "my_locations",
        "_id" : "3",
        "_score" : 1.0,
        "_source" : {
          "location" : "POINT(2.336389 48.861111)",
          "city" : "Paris",
          "name" : "Musée du Louvre"
        }
      }
    ]
  }
}
```