﻿---
title: Fuzzy query
description: Returns documents that contain terms similar to the search term, as measured by a Levenshtein edit distance. An edit distance is the number of one-character...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-fuzzy-query
products:
  - Elasticsearch
---

# Fuzzy query
Returns documents that contain terms similar to the search term, as measured by a [Levenshtein edit distance](https://en.wikipedia.org/wiki/Levenshtein_distance).
An edit distance is the number of one-character changes needed to turn one term into another. These changes can include:
- Changing a character (**b**ox → **f**ox)
- Removing a character (**b**lack → lack)
- Inserting a character (sic → sic**k**)
- Transposing two adjacent characters (**ac**t → **ca**t)

To find similar terms, the `fuzzy` query creates a set of all possible variations, or expansions, of the search term within a specified edit distance. The query then returns exact matches for each expansion.

## Example requests


### Simple example

```json

{
  "query": {
    "fuzzy": {
      "user.id": {
        "value": "ki"
      }
    }
  }
}
```


### Example using advanced parameters

```json

{
  "query": {
    "fuzzy": {
      "user.id": {
        "value": "ki",
        "fuzziness": "AUTO",
        "max_expansions": 50,
        "prefix_length": 0,
        "transpositions": true,
        "rewrite": "constant_score_blended"
      }
    }
  }
}
```


## Top-level parameters for `fuzzy`

<definitions>
  <definition term="<field>">
    (Required, object) Field you wish to search.
  </definition>
</definitions>


## Parameters for `<field>`

<definitions>
  <definition term="value">
    (Required, string) Term you wish to find in the provided `<field>`.
  </definition>
  <definition term="fuzziness">
    (Optional, string) Maximum edit distance allowed for matching. See [Fuzziness](/docs/reference/elasticsearch/rest-apis/common-options#fuzziness) for valid values and more information.
  </definition>
  <definition term="max_expansions">
    (Optional, integer) Maximum number of variations created. Defaults to `50`.
  </definition>
</definitions>

<warning>
  Avoid using a high value in the `max_expansions` parameter, especially if the `prefix_length` parameter value is `0`. High values in the `max_expansions` parameter can cause poor performance due to the high number of variations examined.
</warning>

<definitions>
  <definition term="prefix_length">
    (Optional, integer) Number of beginning characters left unchanged when creating expansions. Defaults to `0`.
  </definition>
  <definition term="transpositions">
    (Optional, Boolean) Indicates whether edits include transpositions of two adjacent characters (ab → ba). Defaults to `true`.
  </definition>
  <definition term="rewrite">
    (Optional, string) Method used to rewrite the query. For valid values and more information, see the [`rewrite` parameter](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-multi-term-rewrite).
  </definition>
</definitions>


## Notes

Fuzzy queries will not be executed if [`search.allow_expensive_queries`](/docs/reference/query-languages/querydsl#query-dsl-allow-expensive-queries) is set to false.