﻿---
title: Exists query
description: Returns documents that contain an indexed value for a field. An indexed value may not exist for a document’s field due to a variety of reasons: The field...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-exists-query
products:
  - Elasticsearch
---

# Exists query
Returns documents that contain an indexed value for a field.
An indexed value may not exist for a document’s field due to a variety of reasons:
- The field in the source JSON is `null` or `[]`
- The field has `"index" : false` and `"doc_values" : false` set in the mapping
- The length of the field value exceeded an `ignore_above` setting in the mapping
- The field value was malformed and `ignore_malformed` was defined in the mapping


## Example request

```json

{
  "query": {
    "exists": {
      "field": "user"
    }
  }
}
```


## Top-level parameters for `exists`

<definitions>
  <definition term="field">
    (Required, string) Name of the field you wish to search.
    While a field is deemed non-existent if the JSON value is `null` or `[]`, these values will indicate the field does exist:
    - Empty strings, such as `""` or `"-"`
    - Arrays containing `null` and another value, such as `[null, "foo"]`
    - A custom [`null-value`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/null-value), defined in field mapping
  </definition>
</definitions>


## Notes


### Find documents missing indexed values

To find documents that are missing an indexed value for a field, use the `must_not` [boolean query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) with the `exists` query.
The following search returns documents that are missing an indexed value for the `user.id` field.
```json

{
  "query": {
    "bool": {
      "must_not": {
        "exists": {
          "field": "user.id"
        }
      }
    }
  }
}
```