﻿---
title: Constant score query
description: Wraps a filter query and returns every matching document with a relevance score equal to the boost parameter value. Filter queries do not calculate relevance...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-constant-score-query
products:
  - Elasticsearch
---

# Constant score query
Wraps a [filter query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) and returns every matching document with a [relevance score](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) equal to the `boost` parameter value.
```json

{
  "query": {
    "constant_score": {
      "filter": {
        "term": { "user.id": "kimchy" }
      },
      "boost": 1.2
    }
  }
}
```


## Top-level parameters for `constant_score`

<definitions>
  <definition term="filter">
    (Required, query object) [Filter query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) you wish to run. Any returned documents must match this query.
  </definition>
</definitions>

Filter queries do not calculate [relevance scores](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores). To speed up performance, Elasticsearch automatically caches frequently used filter queries.
<definitions>
  <definition term="boost">
    (Optional, float) Floating point number used as the constant [relevance score](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) for every document matching the `filter` query. Defaults to `1.0`.
  </definition>
</definitions>