﻿---
title: Boosting query
description: Returns documents matching a positive query while reducing the relevance score of documents that also match a negative query. You can use the boosting...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-boosting-query
products:
  - Elasticsearch
---

# Boosting query
Returns documents matching a `positive` query while reducing the [relevance score](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) of documents that also match a `negative` query.
You can use the `boosting` query to demote certain documents without excluding them from the search results.

## Example request

```json

{
  "query": {
    "boosting": {
      "positive": {
        "term": {
          "text": "apple"
        }
      },
      "negative": {
        "term": {
          "text": "pie tart fruit crumble tree"
        }
      },
      "negative_boost": 0.5
    }
  }
}
```


## Top-level parameters for `boosting`

<definitions>
  <definition term="positive">
    (Required, query object) Query you wish to run. Any returned documents must match this query.
  </definition>
  <definition term="negative">
    (Required, query object) Query used to decrease the [relevance score](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) of matching documents.
  </definition>
</definitions>

If a returned document matches the `positive` query and this query, the `boosting` query calculates the final [relevance score](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) for the document as follows:
1. Take the original relevance score from the `positive` query.
2. Multiply the score by the `negative_boost` value.

<definitions>
  <definition term="negative_boost">
    (Required, float) Floating point number between `0` and `1.0` used to decrease the [relevance scores](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) of documents matching the `negative` query.
  </definition>
</definitions>