﻿---
title: Joining queries
description: Performing full SQL-style joins in a distributed system like Elasticsearch is prohibitively expensive. Instead, Elasticsearch offers two forms of join...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/joining-queries
products:
  - Elasticsearch
---

# Joining queries
Performing full SQL-style joins in a distributed system like Elasticsearch is prohibitively expensive. Instead, Elasticsearch offers two forms of join which are designed to scale horizontally.
<definitions>
  <definition term="nested query">
    Documents may contain fields of type [`nested`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/nested). These fields are used to index arrays of objects, where each object can be queried (with the `nested` query) as an independent document.
  </definition>
  <definition term="has_child and has_parent queries">
    A [`join` field relationship](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/parent-join) can exist between documents within a single index. The `has_child` query returns parent documents whose child documents match the specified query, while the `has_parent` query returns child documents whose parent document matches the specified query.
  </definition>
</definitions>

Also see the [terms-lookup mechanism](/docs/reference/query-languages/query-dsl/query-dsl-terms-query#query-dsl-terms-lookup) in the `terms` query, which allows you to build a `terms` query from values contained in another document.

## Notes


### Allow expensive queries

Joining queries will not be executed if [`search.allow_expensive_queries`](/docs/reference/query-languages/querydsl#query-dsl-allow-expensive-queries) is set to false.