﻿---
title: Geo queries
description: Elasticsearch supports two types of geo data: geo_point fields which support lat/lon pairs, and geo_shape fields, which support points, lines, circles,...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/geo-queries
products:
  - Elasticsearch
---

# Geo queries
Elasticsearch supports two types of geo data: [`geo_point`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) fields which support lat/lon pairs, and [`geo_shape`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape) fields, which support points, lines, circles, polygons, multi-polygons, etc.
The queries in this group are:
<definitions>
  <definition term="geo_bounding_box query">
    Finds documents with geoshapes or geopoints which intersect the specified rectangle.
  </definition>
  <definition term="geo_distance query">
    Finds documents with geoshapes or geopoints within the specified distance of a central point.
  </definition>
  <definition term="geo_grid query">
    Finds documents with:
    - Geoshapes or geopoints which intersect the specified geohash
    - Geoshapes or geopoints which intersect the specified map tile
    - Geopoints which intersect the specified H3 bin
  </definition>
  <definition term="geo_polygon query">
    Find documents with geoshapes or geopoints which intersect the specified polygon.
  </definition>
  <definition term="geo_shape query">
    Finds documents with geoshapes or geopoints which are related to the specified geoshape. Possible spatial relationships to specify are: intersects, contained, within and disjoint.
  </definition>
</definitions>