﻿---
title: Full text queries
description: The full text queries enable you to search analyzed text fields such as the body of an email. The query string is processed using the same analyzer that...
url: https://www.elastic.co/docs/reference/query-languages/query-dsl/full-text-queries
products:
  - Elasticsearch
---

# Full text queries
The full text queries enable you to search [analyzed text fields](https://www.elastic.co/docs/manage-data/data-store/text-analysis) such as the body of an email. The query string is processed using the same analyzer that was applied to the field during indexing.
The queries in this group are:
<definitions>
  <definition term="intervals query">
    A full text query that allows fine-grained control of the ordering and proximity of matching terms.
  </definition>
  <definition term="match query">
    The standard query for performing full text queries, including fuzzy matching and phrase or proximity queries.
  </definition>
  <definition term="match_bool_prefix query">
    Creates a `bool` query that matches each term as a `term` query, except for the last term, which is matched as a `prefix` query
  </definition>
  <definition term="match_phrase query">
    Like the `match` query but used for matching exact phrases or word proximity matches.
  </definition>
  <definition term="match_phrase_prefix query">
    Like the `match_phrase` query, but does a wildcard search on the final word.
  </definition>
  <definition term="multi_match query">
    The multi-field version of the `match` query.
  </definition>
  <definition term="combined_fields query">
    Matches over multiple fields as if they had been indexed into one combined field.
  </definition>
  <definition term="query_string query">
    Supports the compact Lucene [query string syntax](/docs/reference/query-languages/query-dsl/query-dsl-query-string-query#query-string-syntax), allowing you to specify ANDORNOT conditions and multi-field search within a single query string. For expert users only.
  </definition>
  <definition term="simple_query_string query">
    A simpler, more robust version of the `query_string` syntax suitable for exposing directly to users.
  </definition>
</definitions>