﻿---
title: ES|QL time series aggregation functions
description: The first STATS under a TS source command supports aggregation functions per time series. These functions accept up to two arguments. The first argument...
url: https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions
products:
  - Elasticsearch
---

# ES|QL time series aggregation functions
The first [`STATS`](https://www.elastic.co/docs/reference/query-languages/esql/commands/stats-by) under a [`TS`](https://www.elastic.co/docs/reference/query-languages/esql/commands/ts) source command supports
aggregation functions per time series. These functions accept up to two arguments.
The first argument is required and denotes the metric name of the time series.
The second argument is optional and allows specifying a sliding time window for
aggregating metric values. Note that this is orthogonal to time bucketing of
output results, as specified in the BY clause (e.g. through
[`TBUCKET`](/docs/reference/query-languages/esql/functions-operators/grouping-functions#esql-tbucket)).
For example, the following query calculates the average rate of requests per
host for every minute, using values over a sliding window of 10 minutes:
```esql
TS metrics
  | WHERE TRANGE(1h)
  | STATS AVG(RATE(requests, 10m)) BY TBUCKET(1m), host
```

Accepted window values are currently limited to multiples of the time bucket
interval in the BY clause. If no window is specified, the time bucket interval
is implicitly used as a window.
The following time series aggregation functions are supported:
- [`ABSENT_OVER_TIME`](#esql-absent_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`AVG_OVER_TIME`](#esql-avg_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`COUNT_OVER_TIME`](#esql-count_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`COUNT_DISTINCT_OVER_TIME`](#esql-count_distinct_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`DELTA`](#esql-delta) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`DERIV`](#esql-deriv) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`FIRST_OVER_TIME`](#esql-first_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`IDELTA`](#esql-idelta) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`INCREASE`](#esql-increase) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`IRATE`](#esql-irate) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`LAST_OVER_TIME`](#esql-last_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`MAX_OVER_TIME`](#esql-max_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`MIN_OVER_TIME`](#esql-min_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`PERCENTILE_OVER_TIME`](#esql-percentile_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`PRESENT_OVER_TIME`](#esql-present_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`RATE`](#esql-rate) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`STDDEV_OVER_TIME`](#esql-stddev_over_time) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`SUM_OVER_TIME`](#esql-sum_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`VARIANCE_OVER_TIME`](#esql-variance_over_time) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>


## `ABSENT_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/absent_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the absent over time
  </definition>
</definitions>

**Description**
Calculates the absence of a field in the output result over time range.
**Supported types**

| field                   | window                                                                  | result  |
|-------------------------|-------------------------------------------------------------------------|---------|
| aggregate_metric_double | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| boolean                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| cartesian_point         | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| cartesian_shape         | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| date                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| date_nanos              | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| double                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| exponential_histogram   | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geo_point               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geo_shape               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geohash                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geohex                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geotile                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| histogram               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| integer                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| ip                      | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| keyword                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| long                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| tdigest                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| text                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| unsigned_long           | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| version                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |

**Example**
```esql
TS k8s
| WHERE cluster == "prod" AND pod == "two"
| STATS events_received = MAX(ABSENT_OVER_TIME(events_received)) BY pod, time_bucket = TBUCKET(2 minute)
```


| events_received:boolean | pod:keyword | time_bucket:datetime     |
|-------------------------|-------------|--------------------------|
| false                   | two         | 2024-05-10T00:02:00.000Z |
| false                   | two         | 2024-05-10T00:08:00.000Z |
| true                    | two         | 2024-05-10T00:10:00.000Z |
| true                    | two         | 2024-05-10T00:12:00.000Z |


## `AVG_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/avg_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the average
  </definition>
</definitions>

**Description**
Calculates the average over time of a numeric field.
**Supported types**

| field                   | window                                                                  | result |
|-------------------------|-------------------------------------------------------------------------|--------|
| aggregate_metric_double | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| double                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| exponential_histogram   | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| integer                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| long                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| tdigest                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| STATS max_cost=MAX(AVG_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| max_cost:double | cluster:keyword | time_bucket:datetime     |
|-----------------|-----------------|--------------------------|
| 12.375          | prod            | 2024-05-10T00:17:00.000Z |
| 12.375          | qa              | 2024-05-10T00:01:00.000Z |
| 12.25           | prod            | 2024-05-10T00:19:00.000Z |
| 12.0625         | qa              | 2024-05-10T00:06:00.000Z |


## `COUNT_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/count_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the count over time
  </definition>
</definitions>

**Description**
Calculates the count over time value of a field.
**Supported types**

| field                   | window                                                                  | result |
|-------------------------|-------------------------------------------------------------------------|--------|
| aggregate_metric_double | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| boolean                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| cartesian_point         | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| cartesian_shape         | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| date                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| date_nanos              | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| double                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| geo_point               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| geo_shape               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| geohash                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| geohex                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| geotile                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| integer                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| ip                      | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| keyword                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| long                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| text                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| unsigned_long           | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| version                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |

**Example**
```esql
TS k8s
| STATS count=COUNT(COUNT_OVER_TIME(network.cost))
  BY cluster, time_bucket = BUCKET(@timestamp,1minute)
```


| count:long | cluster:keyword | time_bucket:datetime     |
|------------|-----------------|--------------------------|
| 3          | staging         | 2024-05-10T00:22:00.000Z |
| 3          | prod            | 2024-05-10T00:20:00.000Z |
| 3          | prod            | 2024-05-10T00:19:00.000Z |


## `COUNT_DISTINCT_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/count_distinct_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="precision">
    Precision threshold. Refer to [`AGG-COUNT-DISTINCT-APPROXIMATE`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-agg-count-distinct-approximate). The maximum supported value is 40000. Thresholds above this number will have the same effect as a threshold of 40000. The default value is 3000.
  </definition>
</definitions>

**Description**
Calculates the count of distinct values over time for a field.
**Supported types**

| field      | precision     | result |
|------------|---------------|--------|
| boolean    | integer       | long   |
| boolean    | long          | long   |
| boolean    | unsigned_long | long   |
| boolean    |               | long   |
| date       | integer       | long   |
| date       | long          | long   |
| date       | unsigned_long | long   |
| date       |               | long   |
| date_nanos | integer       | long   |
| date_nanos | long          | long   |
| date_nanos | unsigned_long | long   |
| date_nanos |               | long   |
| double     | integer       | long   |
| double     | long          | long   |
| double     | unsigned_long | long   |
| double     |               | long   |
| integer    | integer       | long   |
| integer    | long          | long   |
| integer    | unsigned_long | long   |
| integer    |               | long   |
| ip         | integer       | long   |
| ip         | long          | long   |
| ip         | unsigned_long | long   |
| ip         |               | long   |
| keyword    | integer       | long   |
| keyword    | long          | long   |
| keyword    | unsigned_long | long   |
| keyword    |               | long   |
| long       | integer       | long   |
| long       | long          | long   |
| long       | unsigned_long | long   |
| long       |               | long   |
| text       | integer       | long   |
| text       | long          | long   |
| text       | unsigned_long | long   |
| text       |               | long   |
| version    | integer       | long   |
| version    | long          | long   |
| version    | unsigned_long | long   |
| version    |               | long   |

**Example**
```esql
TS k8s
| STATS distincts=COUNT_DISTINCT(COUNT_DISTINCT_OVER_TIME(network.cost)),
        distincts_imprecise=COUNT_DISTINCT(COUNT_DISTINCT_OVER_TIME(network.cost, 100))
  BY cluster, time_bucket = TBUCKET(1minute)
```


| distincts:long | distincts_imprecise:long | cluster:keyword | time_bucket:datetime     |
|----------------|--------------------------|-----------------|--------------------------|
| 3              | 3                        | qa              | 2024-05-10T00:17:00.000Z |
| 3              | 3                        | qa              | 2024-05-10T00:15:00.000Z |
| 3              | 3                        | prod            | 2024-05-10T00:09:00.000Z |


## `DELTA`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/delta.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the delta over time
  </definition>
</definitions>

**Description**
Calculates the absolute change of a gauge field in a time window.
**Supported types**

| field   | window                                                                  | result |
|---------|-------------------------------------------------------------------------|--------|
| double  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| integer | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| long    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| WHERE pod == "one"
| STATS tx = SUM(DELTA(network.bytes_in)) BY cluster, time_bucket = TBUCKET(10minute)
```


| tx:double | cluster:keyword | time_bucket:datetime     |
|-----------|-----------------|--------------------------|
| -351.0    | prod            | 2024-05-10T00:00:00.000Z |
| 552.0     | qa              | 2024-05-10T00:00:00.000Z |
| 127.0     | staging         | 2024-05-10T00:00:00.000Z |
| 280.0     | prod            | 2024-05-10T00:10:00.000Z |


## `DERIV`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/deriv.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the derivative over time
  </definition>
</definitions>

**Description**
Calculates the derivative over time of a numeric field using linear regression.
**Supported types**

| field   | window | result |
|---------|--------|--------|
| double  |        | double |
| integer |        | double |
| long    |        | double |

**Example**
```esql
TS datenanos-k8s
| WHERE pod == "three"
| STATS max_deriv = MAX(DERIV(network.cost)) BY time_bucket = BUCKET(@timestamp,5minute), pod
```


| max_deriv:double | time_bucket:date_nanos   | pod:keyword |
|------------------|--------------------------|-------------|
| 0.101674         | 2024-05-10T00:00:00.000Z | three       |
| 0.0411           | 2024-05-10T00:05:00.000Z | three       |
| -0.017149        | 2024-05-10T00:10:00.000Z | three       |


## `FIRST_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/first_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the first over time value
  </definition>
</definitions>

**Description**
Calculates the earliest value of a field, where recency determined by the `@timestamp` field.
**Supported types**

| field                 | window                                                                  | result                |
|-----------------------|-------------------------------------------------------------------------|-----------------------|
| counter_double        | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double                |
| counter_integer       | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | integer               |
| counter_long          | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long                  |
| double                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double                |
| exponential_histogram | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | exponential_histogram |
| integer               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | integer               |
| long                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long                  |

**Example**
```esql
TS k8s
| STATS max_cost=MAX(FIRST_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| max_cost:double | cluster:keyword | time_bucket:datetime     |
|-----------------|-----------------|--------------------------|
| 12.375          | prod            | 2024-05-10T00:17:00.000Z |
| 12.375          | qa              | 2024-05-10T00:01:00.000Z |
| 12.25           | prod            | 2024-05-10T00:19:00.000Z |


## `IDELTA`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/idelta.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the idelta over time
  </definition>
</definitions>

**Description**
Calculates the idelta of a gauge. idelta is the absolute change between the last two data points (it ignores all but the last two data points in each time period). This function is very similar to delta, but is more responsive to recent changes.
**Supported types**

| field   | window                                                                  | result |
|---------|-------------------------------------------------------------------------|--------|
| double  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| integer | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| long    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| STATS events = SUM(IDELTA(events_received)) by pod, time_bucket = TBUCKET(10minute)
```


| events:double | pod:keyword | time_bucket:datetime     |
|---------------|-------------|--------------------------|
| 9.0           | one         | 2024-05-10T00:10:00.000Z |
| 7.0           | three       | 2024-05-10T00:10:00.000Z |
| 3.0           | two         | 2024-05-10T00:00:00.000Z |
| 0.0           | two         | 2024-05-10T00:20:00.000Z |


## `INCREASE`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/increase.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the increase over time
  </definition>
</definitions>

**Description**
Calculates the absolute increase of a counter field in a time window.
**Supported types**

| field           | window                                                                  | result |
|-----------------|-------------------------------------------------------------------------|--------|
| counter_double  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| counter_integer | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| counter_long    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| WHERE pod == "one"
| STATS increase_bytes_in = SUM(INCREASE(network.total_bytes_in)) BY cluster, time_bucket = TBUCKET(10minute)
```


| increase_bytes_in:double | cluster:keyword | time_bucket:datetime     |
|--------------------------|-----------------|--------------------------|
| 2453.5                   | prod            | 2024-05-10T00:00:00.000Z |
| 5828.87                  | qa              | 2024-05-10T00:00:00.000Z |
| 2591.440476190476        | staging         | 2024-05-10T00:00:00.000Z |


## `IRATE`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/irate.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the irate
  </definition>
</definitions>

**Description**
Calculates the irate of a counter field. irate is the per-second rate of increase between the last two data points (it ignores all but the last two data points in each time period). This function is very similar to rate, but is more responsive to recent changes in the rate of increase.
**Supported types**

| field           | window                                                                  | result |
|-----------------|-------------------------------------------------------------------------|--------|
| counter_double  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| counter_integer | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| counter_long    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s | WHERE pod == "one"
| STATS irate_bytes_in = SUM(IRATE(network.total_bytes_in)) BY cluster, time_bucket = TBUCKET(10minute)
```


| irate_bytes_in:double | cluster:keyword | time_bucket:datetime     |
|-----------------------|-----------------|--------------------------|
| 0.07692307692307693   | prod            | 2024-05-10T00:00:00.000Z |
| 830.0                 | qa              | 2024-05-10T00:00:00.000Z |
| 31.375                | staging         | 2024-05-10T00:00:00.000Z |
| 9.854545454545454     | prod            | 2024-05-10T00:10:00.000Z |
| 18.700000000000003    | qa              | 2024-05-10T00:10:00.000Z |


## `LAST_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/last_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the latest value for
  </definition>
  <definition term="window">
    the time window over which to find the latest value
  </definition>
</definitions>

**Description**
Calculates the latest value of a field, where recency determined by the `@timestamp` field.
**Supported types**

| field                 | window                                                                  | result                |
|-----------------------|-------------------------------------------------------------------------|-----------------------|
| counter_double        | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double                |
| counter_integer       | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | integer               |
| counter_long          | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long                  |
| double                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double                |
| exponential_histogram | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | exponential_histogram |
| integer               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | integer               |
| long                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long                  |

**Example**
```esql
TS k8s
| STATS max_cost=MAX(LAST_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| max_cost:double | cluster:keyword | time_bucket:datetime     |
|-----------------|-----------------|--------------------------|
| 12.5            | staging         | 2024-05-10T00:09:00.000Z |
| 12.375          | prod            | 2024-05-10T00:17:00.000Z |
| 12.375          | qa              | 2024-05-10T00:06:00.000Z |
| 12.375          | qa              | 2024-05-10T00:01:00.000Z |


## `MAX_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/max_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the maximum
  </definition>
</definitions>

**Description**
Calculates the maximum over time value of a field.
**Supported types**

| field                                                                               | window                                                                  | result        |
|-------------------------------------------------------------------------------------|-------------------------------------------------------------------------|---------------|
| aggregate_metric_double                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| boolean                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean       |
| date                                                                                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | date          |
| date_nanos                                                                          | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | date_nanos    |
| double                                                                              | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| exponential_histogram                                                               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| integer                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | integer       |
| ip                                                                                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | ip            |
| keyword                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | keyword       |
| long                                                                                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long          |
| tdigest                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| text                                                                                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | keyword       |
| unsigned_long <applies-to>Elastic Stack: Generally available since 9.2</applies-to> | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | unsigned_long |
| version                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | version       |

**Example**
```esql
TS k8s
| STATS cost=SUM(MAX_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| cost:double | cluster:keyword | time_bucket:datetime     |
|-------------|-----------------|--------------------------|
| 32.75       | qa              | 2024-05-10T00:17:00.000Z |
| 32.25       | staging         | 2024-05-10T00:09:00.000Z |
| 31.75       | qa              | 2024-05-10T00:06:00.000Z |
| 29.0        | prod            | 2024-05-10T00:19:00.000Z |


## `MIN_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/min_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the minimum
  </definition>
</definitions>

**Description**
Calculates the minimum over time value of a field.
**Supported types**

| field                                                                               | window                                                                  | result        |
|-------------------------------------------------------------------------------------|-------------------------------------------------------------------------|---------------|
| aggregate_metric_double                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| boolean                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean       |
| date                                                                                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | date          |
| date_nanos                                                                          | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | date_nanos    |
| double                                                                              | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| exponential_histogram                                                               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| integer                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | integer       |
| ip                                                                                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | ip            |
| keyword                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | keyword       |
| long                                                                                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long          |
| tdigest                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double        |
| text                                                                                | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | keyword       |
| unsigned_long <applies-to>Elastic Stack: Generally available since 9.2</applies-to> | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | unsigned_long |
| version                                                                             | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | version       |

**Example**
```esql
TS k8s
| STATS cost=SUM(MIN_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| cost:double | cluster:keyword | time_bucket:datetime     |
|-------------|-----------------|--------------------------|
| 29.0        | prod            | 2024-05-10T00:19:00.000Z |
| 27.625      | qa              | 2024-05-10T00:06:00.000Z |
| 24.25       | qa              | 2024-05-10T00:09:00.000Z |


## `PERCENTILE_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/percentile_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="percentile">
    the percentile value to compute (between 0 and 100)
  </definition>
</definitions>

**Description**
Calculates the percentile over time of a field.
**Supported types**

| field                 | percentile | result |
|-----------------------|------------|--------|
| double                | double     | double |
| double                | integer    | double |
| double                | long       | double |
| exponential_histogram | double     | double |
| exponential_histogram | integer    | double |
| exponential_histogram | long       | double |
| integer               | double     | double |
| integer               | integer    | double |
| integer               | long       | double |
| long                  | double     | double |
| long                  | integer    | double |
| long                  | long       | double |
| tdigest               | double     | double |
| tdigest               | integer    | double |
| tdigest               | long       | double |

**Example**
```esql
TS k8s
| STATS p95_cost=MAX(PERCENTILE_OVER_TIME(network.cost, 95)), p99_cost=MAX(PERCENTILE_OVER_TIME(network.cost, 99)) BY cluster, time_bucket = TBUCKET(1minute)
```


## `PRESENT_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/present_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the present over time
  </definition>
</definitions>

**Description**
Calculates the presence of a field in the output result over time range.
**Supported types**

| field                   | window                                                                  | result  |
|-------------------------|-------------------------------------------------------------------------|---------|
| aggregate_metric_double | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| boolean                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| cartesian_point         | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| cartesian_shape         | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| date                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| date_nanos              | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| double                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| exponential_histogram   | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geo_point               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geo_shape               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geohash                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geohex                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| geotile                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| histogram               | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| integer                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| ip                      | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| keyword                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| long                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| tdigest                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| text                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| unsigned_long           | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |
| version                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | boolean |

**Example**
```esql
TS k8s
| WHERE cluster == "prod" AND pod == "two"
| STATS events_received = MAX(PRESENT_OVER_TIME(events_received)) BY pod, time_bucket = TBUCKET(2 minute)
```


| events_received:boolean | pod:keyword | time_bucket:datetime     |
|-------------------------|-------------|--------------------------|
| true                    | two         | 2024-05-10T00:02:00.000Z |
| true                    | two         | 2024-05-10T00:08:00.000Z |
| false                   | two         | 2024-05-10T00:10:00.000Z |
| false                   | two         | 2024-05-10T00:12:00.000Z |


## `RATE`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/rate.svg)

**Parameters**
<definitions>
  <definition term="field">
    the counter field whose per-second average rate of increase is computed
  </definition>
  <definition term="window">
    the time window over which the rate is computed
  </definition>
</definitions>

**Description**
Calculates the per-second average rate of increase of a [counter](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds#time-series-metric). Rate calculations account for breaks in monotonicity, such as counter resets when a service restarts, and extrapolate values within each bucketed time interval. Rate is the most appropriate aggregate function for counters. It is only allowed in a [STATS](https://www.elastic.co/docs/reference/query-languages/esql/commands/stats-by) command under a [`TS`](https://www.elastic.co/docs/reference/query-languages/esql/commands/ts) source command, to be properly applied per time series.
**Supported types**

| field           | window                                                                  | result |
|-----------------|-------------------------------------------------------------------------|--------|
| counter_double  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| counter_integer | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| counter_long    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| STATS max_rate=MAX(RATE(network.total_bytes_in)) BY time_bucket = TBUCKET(5minute)
```


| max_rate: double | time_bucket:date         |
|------------------|--------------------------|
| 64.5             | 2024-05-10T00:20:00.000Z |
| 22.359074        | 2024-05-10T00:15:00.000Z |


## `STDDEV_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/stddev_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the standard deviation for
  </definition>
  <definition term="window">
    the time window over which to compute the standard deviation over time
  </definition>
</definitions>

**Description**
Calculates the population standard deviation over time of a numeric field.
**Supported types**

| field   | window                                                                  | result |
|---------|-------------------------------------------------------------------------|--------|
| double  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| integer | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| long    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| STATS max_stddev_cost=MAX(STDDEV_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| cluster:keyword | time_bucket:datetime     | max_stddev_cost:double |
|-----------------|--------------------------|------------------------|
| staging         | 2024-05-10T00:03:00.000Z | 5.4375                 |
| staging         | 2024-05-10T00:09:00.000Z | 5.1875                 |
| qa              | 2024-05-10T00:18:00.000Z | 4.097764               |
| qa              | 2024-05-10T00:21:00.000Z | 4.0                    |
| staging         | 2024-05-10T00:20:00.000Z | 3.9375                 |


## `VARIANCE_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/variance_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the variance over time
  </definition>
</definitions>

**Description**
Calculates the population variance over time of a numeric field.
**Supported types**

| field   | window                                                                  | result |
|---------|-------------------------------------------------------------------------|--------|
| double  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| integer | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| long    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| STATS avg_var_cost=AVG(VARIANCE_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| cluster:keyword | time_bucket:datetime     | avg_var_cost:double |
|-----------------|--------------------------|---------------------|
| staging         | 2024-05-10T00:03:00.000Z | 20.478516           |
| qa              | 2024-05-10T00:21:00.000Z | 16.0                |
| qa              | 2024-05-10T00:18:00.000Z | 11.192274           |
| staging         | 2024-05-10T00:09:00.000Z | 10.446904           |


## `SUM_OVER_TIME`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/sum_over_time.svg)

**Parameters**
<definitions>
  <definition term="field">
    the metric field to calculate the value for
  </definition>
  <definition term="window">
    the time window over which to compute the sum over time
  </definition>
</definitions>

**Description**
Calculates the sum over time value of a field.
**Supported types**

| field                   | window                                                                  | result |
|-------------------------|-------------------------------------------------------------------------|--------|
| aggregate_metric_double | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| double                  | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| exponential_histogram   | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |
| integer                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| long                    | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | long   |
| tdigest                 | time_duration <applies-to>Elastic Stack: Preview since 9.3</applies-to> | double |

**Example**
```esql
TS k8s
| STATS sum_cost=SUM(SUM_OVER_TIME(network.cost)) BY cluster, time_bucket = TBUCKET(1minute)
```


| sum_cost:double | cluster:keyword | time_bucket:datetime     |
|-----------------|-----------------|--------------------------|
| 67.625          | qa              | 2024-05-10T00:17:00.000Z |
| 65.75           | staging         | 2024-05-10T00:09:00.000Z |