﻿---
title: ES|QL Search functions
description: Use these functions for full-text search and semantic search. Full text functions can be used to match multivalued fields. A multivalued field that contains...
url: https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/search-functions
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ES|QL Search functions
<tip>
  Get started with ES|QL for search use cases with
  our [hands-on tutorial](https://www.elastic.co/docs/reference/query-languages/esql/esql-search-tutorial).For a high-level overview of search functionalities in ES|QL, and to learn about relevance scoring, refer to [ES|QL for search](https://www.elastic.co/docs/solutions/search/esql-for-search#esql-for-search-scoring).For information regarding dense vector search functions,
  including [KNN](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-knn), please refer to
  the [Dense vector functions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/dense-vector-functions) documentation.
</tip>

Use these functions for [full-text search](https://www.elastic.co/docs/solutions/search/full-text)
and [semantic search](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text).
Full text functions can be used to
match [multivalued fields](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields).
A multivalued field that contains a value that matches a full text query is
considered to match the query.
Full text functions are significantly more performant for text search use cases
on large data sets than using pattern matching or regular expressions with
`LIKE` or `RLIKE`.
See [full text search limitations](/docs/reference/query-languages/esql/limitations#esql-limitations-full-text-search)
for information on the limitations of full text search.
ES|QL supports these full-text search functions:
- [`DECAY`](#esql-decay) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
- [`KQL`](#esql-kql)
- [`MATCH`](#esql-match)
- [`MATCH_PHRASE`](#esql-match_phrase)
- [`QSTR`](#esql-qstr)
- [`SCORE`](#esql-score) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>

- [`TOP_SNIPPETS`](#esql-top_snippets) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>


## `DECAY`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/decay.svg)

**Parameters**
<definitions>
  <definition term="value">
    The input value to apply decay scoring to.
  </definition>
  <definition term="origin">
    Central point from which the distances are calculated.
  </definition>
  <definition term="scale">
    Distance from the origin where the function returns the decay value.
  </definition>
  <definition term="options">
  </definition>
</definitions>

**Description**
Calculates a relevance score that decays based on the distance of a numeric, spatial or date type value from a target origin, using configurable decay functions.
`DECAY` calculates a score between 0 and 1 based on how far a field value is from a specified origin point (called distance).
The distance can be a numeric distance, spatial distance or temporal distance depending on the specific data type.
`DECAY` can use [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params) to specify additional `options`
for the decay function.
For spatial queries, scale and offset for geo points use distance units (e.g., "10km", "5mi"),
while cartesian points use numeric values. For date queries, scale and offset use time_duration values.
For numeric queries you also use numeric values.
**Supported types**

| value           | origin          | scale         | options          | result |
|-----------------|-----------------|---------------|------------------|--------|
| cartesian_point | cartesian_point | double        | named parameters | double |
| date            | date            | time_duration | named parameters | double |
| date_nanos      | date_nanos      | time_duration | named parameters | double |
| double          | double          | double        | named parameters | double |
| geo_point       | geo_point       | keyword       | named parameters | double |
| geo_point       | geo_point       | text          | named parameters | double |
| integer         | integer         | integer       | named parameters | double |
| long            | long            | long          | named parameters | double |

**Supported function named parameters**
<definitions>
  <definition term="offset">
    (double, integer, long, time_duration, keyword, text) Distance from the origin where no decay occurs.
  </definition>
  <definition term="type">
    (keyword) Decay function to use: linear, exponential or gaussian.
  </definition>
  <definition term="decay">
    (double) Multiplier value returned at the scale distance from the origin.
  </definition>
</definitions>

**Example**
```esql
FROM employees
| EVAL decay_result = decay(salary, 0, 100000, {"offset": 5, "decay": 0.5, "type": "linear"})
| SORT decay_result DESC
```


| decay_result:double |
|---------------------|
| 0.873405            |
| 0.8703              |
| 0.870145            |
| 0.867845            |
| 0.86395             |


## `KQL`

<applies-to>
  - Elastic Stack: Generally available since 9.1
  - Elastic Stack: Preview in 9.0
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/kql.svg)

**Parameters**
<definitions>
  <definition term="query">
    Query string in KQL query string format.
  </definition>
  <definition term="options">
    (Optional) KQL additional options as [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params). Available in stack version 9.3.0 and later.
  </definition>
</definitions>

**Description**
Performs a KQL query. Returns true if the provided KQL query string matches the row.
**Supported types**

| query   | options          | result  |
|---------|------------------|---------|
| keyword | named parameters | boolean |
| keyword |                  | boolean |
| text    | named parameters | boolean |
| text    |                  | boolean |

**Supported function named parameters**
<definitions>
  <definition term="boost">
    (float) Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.
  </definition>
  <definition term="time_zone">
    (keyword) UTC offset or IANA time zone used to interpret date literals in the query string.
  </definition>
  <definition term="case_insensitive">
    (boolean) If true, performs case-insensitive matching for keyword fields. Defaults to false.
  </definition>
  <definition term="default_field">
    (keyword) Default field to search if no field is provided in the query string. Supports wildcards (*).
  </definition>
</definitions>

**Examples**
Use KQL to filter by a specific field value
```esql
FROM books
| WHERE KQL("author: Faulkner")
```


| book_no:keyword | author:text                                        |
|-----------------|----------------------------------------------------|
| 2378            | [Carol Faulkner, Holly Byers Ochoa, Lucretia Mott] |
| 2713            | William Faulkner                                   |
| 2847            | Colleen Faulkner                                   |
| 2883            | William Faulkner                                   |
| 3293            | Danny Faulkner                                     |

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

Use KQL with additional options for case-insensitive matching and custom settings
```esql
FROM employees
| WHERE KQL("mary", {"case_insensitive": true, "default_field": "first_name", "boost": 1.5})
```


## `MATCH`

<applies-to>
  - Elastic Stack: Generally available since 9.1
  - Elastic Stack: Preview in 9.0
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/match.svg)

**Parameters**
<definitions>
  <definition term="field">
    Field that the query will target.
  </definition>
  <definition term="query">
    Value to find in the provided field.
  </definition>
  <definition term="options">
    (Optional) Match additional options as [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params).
  </definition>
</definitions>

**Description**
Use `MATCH` to perform a [match query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query) on the specified field. Using `MATCH` is equivalent to using the `match` query in the Elasticsearch Query DSL.
Match can be used on fields from the text family like [text](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) and [semantic_text](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text),
as well as other field types like keyword, boolean, dates, and numeric types.
When Match is used on a [semantic_text](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text) field, it will perform a semantic query on the field.
Match can use [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params) to specify additional options
for the match query.
All [match query parameters](/docs/reference/query-languages/query-dsl/query-dsl-match-query#match-field-params) are supported.
For a simplified syntax, you can use the [match operator](/docs/reference/query-languages/esql/functions-operators/operators#esql-match-operator) `:` operator instead of `MATCH`.
`MATCH` returns true if the provided query matches the row.
**Supported types**

| field         | query         | options          | result  |
|---------------|---------------|------------------|---------|
| boolean       | boolean       | named parameters | boolean |
| boolean       | keyword       | named parameters | boolean |
| date          | date          | named parameters | boolean |
| date          | keyword       | named parameters | boolean |
| date_nanos    | date_nanos    | named parameters | boolean |
| date_nanos    | keyword       | named parameters | boolean |
| double        | double        | named parameters | boolean |
| double        | integer       | named parameters | boolean |
| double        | keyword       | named parameters | boolean |
| double        | long          | named parameters | boolean |
| integer       | double        | named parameters | boolean |
| integer       | integer       | named parameters | boolean |
| integer       | keyword       | named parameters | boolean |
| integer       | long          | named parameters | boolean |
| ip            | ip            | named parameters | boolean |
| ip            | keyword       | named parameters | boolean |
| keyword       | keyword       | named parameters | boolean |
| long          | double        | named parameters | boolean |
| long          | integer       | named parameters | boolean |
| long          | keyword       | named parameters | boolean |
| long          | long          | named parameters | boolean |
| text          | keyword       | named parameters | boolean |
| unsigned_long | double        | named parameters | boolean |
| unsigned_long | integer       | named parameters | boolean |
| unsigned_long | keyword       | named parameters | boolean |
| unsigned_long | long          | named parameters | boolean |
| unsigned_long | unsigned_long | named parameters | boolean |
| version       | keyword       | named parameters | boolean |
| version       | version       | named parameters | boolean |

**Supported function named parameters**
<definitions>
  <definition term="fuzziness">
    (keyword) Maximum edit distance allowed for matching.
  </definition>
  <definition term="auto_generate_synonyms_phrase_query">
    (boolean) If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.
  </definition>
  <definition term="analyzer">
    (keyword) Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.
  </definition>
  <definition term="minimum_should_match">
    (integer) Minimum number of clauses that must match for a document to be returned.
  </definition>
  <definition term="zero_terms_query">
    (keyword) Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.
  </definition>
  <definition term="boost">
    (float) Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.
  </definition>
  <definition term="fuzzy_transpositions">
    (boolean) If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.
  </definition>
  <definition term="fuzzy_rewrite">
    (keyword) Method used to rewrite the query. See the rewrite parameter for valid values and more information. If the fuzziness parameter is not 0, the match query uses a fuzzy_rewrite method of top_terms_blended_freqs_${max_expansions} by default.
  </definition>
  <definition term="prefix_length">
    (integer) Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.
  </definition>
  <definition term="lenient">
    (boolean) If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.
  </definition>
  <definition term="operator">
    (keyword) Boolean logic used to interpret text in the query value. Defaults to OR.
  </definition>
  <definition term="max_expansions">
    (integer) Maximum number of terms to which the query will expand. Defaults to 50.
  </definition>
</definitions>

**Examples**
```esql
FROM books
| WHERE MATCH(author, "Faulkner")
```


| book_no:keyword | author:text                                        |
|-----------------|----------------------------------------------------|
| 2378            | [Carol Faulkner, Holly Byers Ochoa, Lucretia Mott] |
| 2713            | William Faulkner                                   |
| 2847            | Colleen Faulkner                                   |
| 2883            | William Faulkner                                   |
| 3293            | Danny Faulkner                                     |

```esql
FROM books
| WHERE MATCH(title, "Hobbit Back Again", {"operator": "AND"})
| KEEP title;
```


| title:text                         |
|------------------------------------|
| The Hobbit or There and Back Again |


## `MATCH_PHRASE`

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/match_phrase.svg)

**Parameters**
<definitions>
  <definition term="field">
    Field that the query will target.
  </definition>
  <definition term="query">
    Value to find in the provided field.
  </definition>
  <definition term="options">
    (Optional) MatchPhrase additional options as [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params). See [`match_phrase`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query-phrase) for more information.
  </definition>
</definitions>

**Description**
Use `MATCH_PHRASE` to perform a [`match_phrase`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query-phrase) on the specified field. Using `MATCH_PHRASE` is equivalent to using the `match_phrase` query in the Elasticsearch Query DSL.
MatchPhrase can be used on [text](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) fields, as well as other field types like keyword, boolean, or date types.
MatchPhrase is not supported for [semantic_text](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text) or numeric types.
MatchPhrase can use [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params) to specify additional options for the
match_phrase query.
All [`match_phrase`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query-phrase) query parameters are supported.
`MATCH_PHRASE` returns true if the provided query matches the row.
**Supported types**

| field   | query   | options          | result  |
|---------|---------|------------------|---------|
| keyword | keyword | named parameters | boolean |
| text    | keyword | named parameters | boolean |

**Supported function named parameters**
<definitions>
  <definition term="zero_terms_query">
    (keyword) Indicates whether all documents or none are returned if the analyzer removes all tokens, such as when using a stop filter. Defaults to none.
  </definition>
  <definition term="boost">
    (float) Floating point number used to decrease or increase the relevance scores of the query. Defaults to 1.0.
  </definition>
  <definition term="analyzer">
    (keyword) Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the field. If no analyzer is mapped, the index’s default analyzer is used.
  </definition>
  <definition term="slop">
    (integer) Maximum number of positions allowed between matching tokens. Defaults to 0. Transposed terms have a slop of 2.
  </definition>
</definitions>

**Example**
<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

```esql
FROM books
| WHERE MATCH_PHRASE(author, "William Faulkner")
```


| book_no:keyword | author:text      |
|-----------------|------------------|
| 2713            | William Faulkner |
| 2883            | William Faulkner |
| 4724            | William Faulkner |
| 4977            | William Faulkner |
| 5119            | William Faulkner |


## `QSTR`

<applies-to>
  - Elastic Stack: Generally available since 9.1
  - Elastic Stack: Preview in 9.0
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/qstr.svg)

**Parameters**
<definitions>
  <definition term="query">
    Query string in Lucene query string format.
  </definition>
  <definition term="options">
    (Optional) Additional options for Query String as [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params). See [query string query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-query-string-query) for more information.
  </definition>
</definitions>

**Description**
Performs a [query string query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-query-string-query). Returns true if the provided query string matches the row.
**Supported types**

| query   | options          | result  |
|---------|------------------|---------|
| keyword | named parameters | boolean |
| text    | named parameters | boolean |

**Supported function named parameters**
<definitions>
  <definition term="max_determinized_states">
    (integer) Maximum number of automaton states required for the query. Default is 10000.
  </definition>
  <definition term="fuzziness">
    (keyword) Maximum edit distance allowed for matching.
  </definition>
  <definition term="auto_generate_synonyms_phrase_query">
    (boolean) If true, match phrase queries are automatically created for multi-term synonyms. Defaults to true.
  </definition>
  <definition term="phrase_slop">
    (integer) Maximum number of positions allowed between matching tokens for phrases. Defaults to 0 (which means exact matches are required).
  </definition>
  <definition term="default_field">
    (keyword) Default field to search if no field is provided in the query string. Supports wildcards (*).
  </definition>
  <definition term="allow_leading_wildcard">
    (boolean) If true, the wildcard characters * and ? are allowed as the first character of the query string. Defaults to true.
  </definition>
  <definition term="minimum_should_match">
    (string) Minimum number of clauses that must match for a document to be returned.
  </definition>
  <definition term="fuzzy_transpositions">
    (boolean) If true, edits for fuzzy matching include transpositions of two adjacent characters (ab → ba). Defaults to true.
  </definition>
  <definition term="fuzzy_prefix_length">
    (integer) Number of beginning characters left unchanged for fuzzy matching. Defaults to 0.
  </definition>
  <definition term="time_zone">
    (keyword) Coordinated Universal Time (UTC) offset or IANA time zone used to convert date values in the query string to UTC.
  </definition>
  <definition term="lenient">
    (boolean) If false, format-based errors, such as providing a text query value for a numeric field, are returned. Defaults to false.
  </definition>
  <definition term="rewrite">
    (keyword) Method used to rewrite the query.
  </definition>
  <definition term="default_operator">
    (keyword) Default boolean logic used to interpret text in the query string if no operators are specified.
  </definition>
  <definition term="analyzer">
    (keyword) Analyzer used to convert the text in the query value into token. Defaults to the index-time analyzer mapped for the default_field.
  </definition>
  <definition term="fuzzy_max_expansions">
    (integer) Maximum number of terms to which the query expands for fuzzy matching. Defaults to 50.
  </definition>
  <definition term="quote_analyzer">
    (keyword) Analyzer used to convert quoted text in the query string into tokens. Defaults to the search_quote_analyzer mapped for the default_field.
  </definition>
  <definition term="allow_wildcard">
    (boolean) If true, the query attempts to analyze wildcard terms in the query string. Defaults to false.
  </definition>
  <definition term="boost">
    (float) Floating point number used to decrease or increase the relevance scores of the query.
  </definition>
  <definition term="quote_field_suffix">
    (keyword) Suffix appended to quoted text in the query string.
  </definition>
  <definition term="enable_position_increments">
    (boolean) If true, enable position increments in queries constructed from a query_string search. Defaults to true.
  </definition>
  <definition term="fields">
    (keyword) Array of fields to search. Supports wildcards (*).
  </definition>
</definitions>

**Examples**
```esql
FROM books
| WHERE QSTR("author: Faulkner")
```


| book_no:keyword | author:text                                        |
|-----------------|----------------------------------------------------|
| 2378            | [Carol Faulkner, Holly Byers Ochoa, Lucretia Mott] |
| 2713            | William Faulkner                                   |
| 2847            | Colleen Faulkner                                   |
| 2883            | William Faulkner                                   |
| 3293            | Danny Faulkner                                     |

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

```esql
FROM books
| WHERE QSTR("title: Hobbjt~", {"fuzziness": 2})
```


| book_no:keyword | title:text                         |
|-----------------|------------------------------------|
| 4289            | Poems from the Hobbit              |
| 6405            | The Hobbit or There and Back Again |
| 7480            | The Hobbit                         |


## `SCORE`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/score.svg)

**Parameters**
<definitions>
  <definition term="query">
    Boolean expression that contains full text function(s) to be scored.
  </definition>
</definitions>

**Description**
Scores an expression. Only full text functions will be scored. Returns scores for all the resulting docs.
**Supported types**

| query   | result |
|---------|--------|
| boolean | double |

**Example**
```esql
FROM books METADATA _score
| WHERE match(title, "Return") AND match(author, "Tolkien")
| EVAL first_score = score(match(title, "Return"))
```


## `TOP_SNIPPETS`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/top_snippets.svg)

**Parameters**
<definitions>
  <definition term="field">
    The input to chunk.
  </definition>
  <definition term="query">
    The input text containing only query terms for snippet extraction. Lucene query syntax, operators, and wildcards are not allowed.
  </definition>
  <definition term="options">
    (Optional) `TOP_SNIPPETS` additional options as [function named parameters](/docs/reference/query-languages/esql/esql-syntax#esql-function-named-params).
  </definition>
</definitions>

**Description**
Use `TOP_SNIPPETS` to extract the best snippets for a given query string from a text field.
`TOP_SNIPPETS` can be used on fields from the text famiy like [text](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) and [semantic_text](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text).
`TOP_SNIPPETS` will extract the best snippets for a given query string.
**Supported types**

| field   | query   | options          | result  |
|---------|---------|------------------|---------|
| keyword | keyword | named parameters | keyword |
| keyword | keyword |                  | keyword |
| text    | keyword | named parameters | keyword |
| text    | keyword |                  | keyword |

**Supported function named parameters**
<definitions>
  <definition term="num_words">
    (integer) The maximum number of words to return in each snippet.
    This allows better control of inference costs by limiting the size of tokens per snippet.
  </definition>
  <definition term="num_snippets">
    (integer) The maximum number of matching snippets to return.
  </definition>
</definitions>

**Examples**
<applies-to>
  - Elastic Stack: Preview since 9.3
</applies-to>

```esql
FROM books
| EVAL snippets = TOP_SNIPPETS(description, "Tolkien")
```


| book_no:keyword | title:text                                            | snippets:keyword                                                                                                                                                                                                                                                         |
|-----------------|-------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 1211            | The brothers Karamazov                                | null                                                                                                                                                                                                                                                                     |
| 1463            | Realms of Tolkien: Images of Middle-earth             | Twenty new and familiar Tolkien artists are represented in this fabulous volume, breathing an extraordinary variety of life into 58 different scenes, each of which is accompanied by appropriate passage from The Hobbit and The Lord of the Rings and The Silmarillion |
| 1502            | Selected Passages from Correspondence with Friends    | null                                                                                                                                                                                                                                                                     |
| 1937            | The Best Short Stories of Dostoevsky (Modern Library) | null                                                                                                                                                                                                                                                                     |
| 1985            | Brothers Karamazov                                    | null                                                                                                                                                                                                                                                                     |

<applies-to>
  - Elastic Stack: Preview since 9.3
</applies-to>

```esql
FROM books
| WHERE MATCH(title, "Return")
| EVAL snippets = TOP_SNIPPETS(description, "Tolkien", { "num_snippets": 3, "num_words": 25 })
```


| book_no:keyword | title:text                                                       | snippets:keyword                                                                                                                                                                                                                                                                                                                                                                                                                                |
|-----------------|------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 2714            | Return of the King Being the Third Part of The Lord of the Rings | [Concluding the story begun in The Hobbit, this is the final part of Tolkien s epic masterpiece, The Lord of the Rings, featuring an exclusive, Tolkien s epic masterpiece, The Lord of the Rings, featuring an exclusive cover image from the film, the definitive text, and a detailed map of, Tolkien s classic tale of magic and adventure, begun in The Fellowship of the Ring and The Two Towers, features the definitive edition of the] |
| 7350            | Return of the Shadow                                             | [Tolkien for long believed would be a far shorter book, 'a sequel to The Hobbit'., In The Return of the Shadow (an abandoned title for the first volume) Christopher Tolkien describes, with full citation of the earliest notes, outline plans, ) Christopher Tolkien describes, with full citation of the earliest notes, outline plans, and narrative drafts, the intricate evolution of The Fellowship of the Ring and]                     |