﻿---
title: ES|QL operators
description: Operators for performing operations on, or comparing against, one or multiple expressions. 
url: https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/operators
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ES|QL operators
Operators for performing operations on, or comparing against, one or multiple expressions.
- [Binary operators](#esql-binary-operators)
- [Unary operators](#esql-unary-operators)
- [Logical operators](#esql-logical-operators)
- [suffix operators](#esql-suffix-operators)
- [infix operators](#esql-infix-operators)


## Binary operators

- [Equality](#esql-equals)
- [Inequality `!=`](#esql-not_equals)
- [Less than `<`](#esql-less_than)
- [Less than or equal to `<=`](#esql-less_than_or_equal)
- [Greater than `>`](#esql-greater_than)
- [Greater than or equal to `>=`](#esql-greater_than_or_equal)
- [Add `+`](#esql-add)
- [Subtract `-`](#esql-sub)
- [Multiply `*`](#esql-mul)
- [Divide `/`](#esql-div)
- [Modulus `%`](#esql-mod)


### Equality

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/equals.svg)

Check if two fields are equal. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
<note>
  This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an [mapping-index](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) and [doc-values](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values).
</note>

**Supported types**

| lhs             | rhs             | result  |
|-----------------|-----------------|---------|
| boolean         | boolean         | boolean |
| cartesian_point | cartesian_point | boolean |
| cartesian_shape | cartesian_shape | boolean |
| date            | date            | boolean |
| date            | date_nanos      | boolean |
| date_nanos      | date            | boolean |
| date_nanos      | date_nanos      | boolean |
| double          | double          | boolean |
| double          | integer         | boolean |
| double          | long            | boolean |
| geo_point       | geo_point       | boolean |
| geo_shape       | geo_shape       | boolean |
| geohash         | geohash         | boolean |
| geohex          | geohex          | boolean |
| geotile         | geotile         | boolean |
| integer         | double          | boolean |
| integer         | integer         | boolean |
| integer         | long            | boolean |
| ip              | ip              | boolean |
| keyword         | keyword         | boolean |
| keyword         | text            | boolean |
| long            | double          | boolean |
| long            | integer         | boolean |
| long            | long            | boolean |
| text            | keyword         | boolean |
| text            | text            | boolean |
| unsigned_long   | unsigned_long   | boolean |
| version         | version         | boolean |


### Inequality `!=`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/not_equals.svg)

Check if two fields are unequal. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
<note>
  This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an [mapping-index](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) and [doc-values](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values).
</note>

**Supported types**

| lhs             | rhs             | result  |
|-----------------|-----------------|---------|
| boolean         | boolean         | boolean |
| cartesian_point | cartesian_point | boolean |
| cartesian_shape | cartesian_shape | boolean |
| date            | date            | boolean |
| date            | date_nanos      | boolean |
| date_nanos      | date            | boolean |
| date_nanos      | date_nanos      | boolean |
| double          | double          | boolean |
| double          | integer         | boolean |
| double          | long            | boolean |
| geo_point       | geo_point       | boolean |
| geo_shape       | geo_shape       | boolean |
| geohash         | geohash         | boolean |
| geohex          | geohex          | boolean |
| geotile         | geotile         | boolean |
| integer         | double          | boolean |
| integer         | integer         | boolean |
| integer         | long            | boolean |
| ip              | ip              | boolean |
| keyword         | keyword         | boolean |
| keyword         | text            | boolean |
| long            | double          | boolean |
| long            | integer         | boolean |
| long            | long            | boolean |
| text            | keyword         | boolean |
| text            | text            | boolean |
| unsigned_long   | unsigned_long   | boolean |
| version         | version         | boolean |


### Less than `<`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/less_than.svg)

Check if one field is less than another. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
<note>
  This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an [mapping-index](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) and [doc-values](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values).
</note>

**Supported types**

| lhs           | rhs           | result  |
|---------------|---------------|---------|
| date          | date          | boolean |
| date          | date_nanos    | boolean |
| date_nanos    | date          | boolean |
| date_nanos    | date_nanos    | boolean |
| double        | double        | boolean |
| double        | integer       | boolean |
| double        | long          | boolean |
| integer       | double        | boolean |
| integer       | integer       | boolean |
| integer       | long          | boolean |
| ip            | ip            | boolean |
| keyword       | keyword       | boolean |
| keyword       | text          | boolean |
| long          | double        | boolean |
| long          | integer       | boolean |
| long          | long          | boolean |
| text          | keyword       | boolean |
| text          | text          | boolean |
| unsigned_long | unsigned_long | boolean |
| version       | version       | boolean |


### Less than or equal to `<=`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/less_than_or_equal.svg)

Check if one field is less than or equal to another. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
<note>
  This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an [mapping-index](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) and [doc-values](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values).
</note>

**Supported types**

| lhs           | rhs           | result  |
|---------------|---------------|---------|
| date          | date          | boolean |
| date          | date_nanos    | boolean |
| date_nanos    | date          | boolean |
| date_nanos    | date_nanos    | boolean |
| double        | double        | boolean |
| double        | integer       | boolean |
| double        | long          | boolean |
| integer       | double        | boolean |
| integer       | integer       | boolean |
| integer       | long          | boolean |
| ip            | ip            | boolean |
| keyword       | keyword       | boolean |
| keyword       | text          | boolean |
| long          | double        | boolean |
| long          | integer       | boolean |
| long          | long          | boolean |
| text          | keyword       | boolean |
| text          | text          | boolean |
| unsigned_long | unsigned_long | boolean |
| version       | version       | boolean |


### Greater than `>`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/greater_than.svg)

Check if one field is greater than another. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
<note>
  This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an [mapping-index](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) and [doc-values](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values).
</note>

**Supported types**

| lhs           | rhs           | result  |
|---------------|---------------|---------|
| date          | date          | boolean |
| date          | date_nanos    | boolean |
| date_nanos    | date          | boolean |
| date_nanos    | date_nanos    | boolean |
| double        | double        | boolean |
| double        | integer       | boolean |
| double        | long          | boolean |
| integer       | double        | boolean |
| integer       | integer       | boolean |
| integer       | long          | boolean |
| ip            | ip            | boolean |
| keyword       | keyword       | boolean |
| keyword       | text          | boolean |
| long          | double        | boolean |
| long          | integer       | boolean |
| long          | long          | boolean |
| text          | keyword       | boolean |
| text          | text          | boolean |
| unsigned_long | unsigned_long | boolean |
| version       | version       | boolean |


### Greater than or equal to `>=`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/greater_than_or_equal.svg)

Check if one field is greater than or equal to another. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
<note>
  This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an [mapping-index](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) and [doc-values](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/doc-values).
</note>

**Supported types**

| lhs           | rhs           | result  |
|---------------|---------------|---------|
| date          | date          | boolean |
| date          | date_nanos    | boolean |
| date_nanos    | date          | boolean |
| date_nanos    | date_nanos    | boolean |
| double        | double        | boolean |
| double        | integer       | boolean |
| double        | long          | boolean |
| integer       | double        | boolean |
| integer       | integer       | boolean |
| integer       | long          | boolean |
| ip            | ip            | boolean |
| keyword       | keyword       | boolean |
| keyword       | text          | boolean |
| long          | double        | boolean |
| long          | integer       | boolean |
| long          | long          | boolean |
| text          | keyword       | boolean |
| text          | text          | boolean |
| unsigned_long | unsigned_long | boolean |
| version       | version       | boolean |


### Add `+`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/add.svg)

Add two numbers together. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
**Supported types**

| lhs           | rhs           | result        |
|---------------|---------------|---------------|
| date          | date_period   | date          |
| date          | time_duration | date          |
| date_nanos    | date_period   | date_nanos    |
| date_nanos    | time_duration | date_nanos    |
| date_period   | date          | date          |
| date_period   | date_nanos    | date_nanos    |
| date_period   | date_period   | date_period   |
| dense_vector  | dense_vector  | dense_vector  |
| double        | double        | double        |
| double        | integer       | double        |
| double        | long          | double        |
| integer       | double        | double        |
| integer       | integer       | integer       |
| integer       | long          | long          |
| long          | double        | double        |
| long          | integer       | long          |
| long          | long          | long          |
| time_duration | date          | date          |
| time_duration | date_nanos    | date_nanos    |
| time_duration | time_duration | time_duration |
| unsigned_long | unsigned_long | unsigned_long |


### Subtract `-`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/sub.svg)

Subtract one number from another. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
**Supported types**

| lhs           | rhs           | result        |
|---------------|---------------|---------------|
| date          | date_period   | date          |
| date          | time_duration | date          |
| date_nanos    | date_period   | date_nanos    |
| date_nanos    | time_duration | date_nanos    |
| date_period   | date_nanos    | date_nanos    |
| date_period   | date_period   | date_period   |
| dense_vector  | dense_vector  | dense_vector  |
| double        | double        | double        |
| double        | integer       | double        |
| double        | long          | double        |
| integer       | double        | double        |
| integer       | integer       | integer       |
| integer       | long          | long          |
| long          | double        | double        |
| long          | integer       | long          |
| long          | long          | long          |
| time_duration | date_nanos    | date_nanos    |
| time_duration | time_duration | time_duration |
| unsigned_long | unsigned_long | unsigned_long |


### Multiply `*`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/mul.svg)

Multiply two numbers together. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
**Supported types**

| lhs           | rhs           | result        |
|---------------|---------------|---------------|
| dense_vector  | dense_vector  | dense_vector  |
| double        | double        | double        |
| double        | integer       | double        |
| double        | long          | double        |
| integer       | double        | double        |
| integer       | integer       | integer       |
| integer       | long          | long          |
| long          | double        | double        |
| long          | integer       | long          |
| long          | long          | long          |
| unsigned_long | unsigned_long | unsigned_long |


### Divide `/`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/div.svg)

Divide one number by another. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
<note>
  Division of two integer types will yield an integer result, rounding towards 0. If you need floating point division, [`Cast (::)`](#esql-cast-operator) one of the arguments to a `DOUBLE`.
</note>

**Supported types**

| lhs           | rhs           | result        |
|---------------|---------------|---------------|
| dense_vector  | dense_vector  | dense_vector  |
| double        | double        | double        |
| double        | integer       | double        |
| double        | long          | double        |
| integer       | double        | double        |
| integer       | integer       | integer       |
| integer       | long          | long          |
| long          | double        | double        |
| long          | integer       | long          |
| long          | long          | long          |
| unsigned_long | unsigned_long | unsigned_long |


### Modulus `%`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/mod.svg)

Divide one number by another and return the remainder. If either field is [multivalued](https://www.elastic.co/docs/reference/query-languages/esql/esql-multivalued-fields) then the result is `null`.
**Supported types**

| lhs           | rhs           | result        |
|---------------|---------------|---------------|
| double        | double        | double        |
| double        | integer       | double        |
| double        | long          | double        |
| integer       | double        | double        |
| integer       | integer       | integer       |
| integer       | long          | long          |
| long          | double        | double        |
| long          | integer       | long          |
| long          | long          | long          |
| unsigned_long | unsigned_long | unsigned_long |


## Unary operators

The only unary operator is negation (`-`):
**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/neg.svg)

**Supported types**

| field         | result        |
|---------------|---------------|
| date_period   | date_period   |
| double        | double        |
| integer       | integer       |
| long          | long          |
| time_duration | time_duration |


## Logical operators

The following logical operators are supported:
- `AND`
- `OR`
- `NOT`


## Suffix operators

- [`IS NULL`](#esql-is_null)
- [`IS NOT NULL`](#esql-is_not_null)


### `IS NULL`

For NULL comparison, use the `IS NULL` and `IS NOT NULL` predicates.
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/is_null.svg)

**Example**
```esql
FROM employees
| WHERE birth_date IS NULL
```


| first_name:keyword | last_name:keyword |
|--------------------|-------------------|
| Basil              | Tramer            |
| Florian            | Syrotiuk          |
| Lucien             | Rosenbaum         |


### `IS NOT NULL`

For NULL comparison, use the `IS NULL` and `IS NOT NULL` predicates.
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/is_not_null.svg)

**Example**
```esql
FROM employees
| WHERE is_rehired IS NOT NULL
| STATS COUNT(emp_no)
```


| COUNT(emp_no):long |
|--------------------|
| 84                 |


## Infix operators

- [Cast `::`](#esql-cast-operator)
- [`IN`](#esql-in-operator)
- [`LIKE`](#esql-like)
- [`RLIKE`](#esql-rlike)
- [Match `:`](#esql-match-operator)


### Cast (`::`)

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/cast.svg)

The `::` operator provides a convenient alternative syntax to the TO_<type> [conversion functions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/type-conversion-functions).
**Example**
```esql
ROW ver = CONCAT(("0"::INT + 1)::STRING, ".2.3")::VERSION
```


| ver:version |
|-------------|
| 1.2.3       |


### `IN`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/in.svg)

The `IN` operator allows testing whether a field or expression equals an element in a list of literals, fields or expressions.
**Example**
```esql
ROW a = 1, b = 4, c = 3
| WHERE c-a IN (3, b / 2, a)
```


| a:integer | b:integer | c:integer |
|-----------|-----------|-----------|
| 1         | 4         | 3         |


### `LIKE`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/like.svg)

Use `LIKE` to filter data based on string patterns using wildcards. `LIKE` usually acts on a field placed on the left-hand side of the operator, but it can also act on a constant (literal) expression. The right-hand side of the operator represents the pattern.
The following wildcard characters are supported:
- `*` matches zero or more characters.
- `?` matches one character.

**Supported types**

| str     | pattern | result  |
|---------|---------|---------|
| keyword | keyword | boolean |
| text    | keyword | boolean |

**Example**
```esql
FROM employees
| WHERE first_name LIKE """?b*"""
| KEEP first_name, last_name
```


| first_name:keyword | last_name:keyword |
|--------------------|-------------------|
| Ebbe               | Callaway          |
| Eberhardt          | Terkki            |

When used on `text` fields, `LIKE` treats the field as a `keyword` and does not use the analyzer.
This means the pattern matching is case-sensitive and must match the exact string indexed.
To perform full-text search, use the `MATCH` or `QSTR` functions.
Matching the exact characters `*` and `.` will require escaping.
The escape character is backslash `\`. Since also backslash is a special character in string literals,
it will require further escaping.
```esql
ROW message = "foo * bar"
| WHERE message LIKE "foo \\* bar"
```

To reduce the overhead of escaping, we suggest using triple quotes strings `"""`
```esql
ROW message = "foo * bar"
| WHERE message LIKE """foo \* bar"""
```

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
</applies-to>

Both a single pattern or a list of patterns are supported. If a list of patterns is provided,
the expression will return true if any of the patterns match.
```esql
ROW message = "foobar"
| WHERE message like ("foo*", "bar?")
```

Patterns may be specified with REST query placeholders as well
```esql
FROM employees
| WHERE first_name LIKE ?pattern
| KEEP first_name, last_name
```

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>


### `RLIKE`

![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/rlike.svg)

Use `RLIKE` to filter data based on string patterns using [regular expressions](https://www.elastic.co/docs/reference/query-languages/query-dsl/regexp-syntax). `RLIKE` usually acts on a field placed on the left-hand side of the operator, but it can also act on a constant (literal) expression. The right-hand side of the operator represents the pattern.
**Supported types**

| str     | pattern | result  |
|---------|---------|---------|
| keyword | keyword | boolean |
| text    | keyword | boolean |

**Example**
```esql
FROM employees
| WHERE first_name RLIKE """.leja.*"""
| KEEP first_name, last_name
```


| first_name:keyword | last_name:keyword |
|--------------------|-------------------|
| Alejandro          | McAlpine          |

When used on `text` fields, `RLIKE` treats the field as a `keyword` and does not use the analyzer.
This means the pattern matching is case-sensitive and must match the exact string indexed.
To perform full-text search, use the `MATCH` or `QSTR` functions.
Matching special characters (eg. `.`, `*`, `(`...) will require escaping.
The escape character is backslash `\`. Since also backslash is a special character in string literals,
it will require further escaping.
```esql
ROW message = "foo ( bar"
| WHERE message RLIKE "foo \\( bar"
```

To reduce the overhead of escaping, we suggest using triple quotes strings `"""`
```esql
ROW message = "foo ( bar"
| WHERE message RLIKE """foo \( bar"""
```

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

Both a single pattern or a list of patterns are supported. If a list of patterns is provided,
the expression will return true if any of the patterns match.
```esql
ROW message = "foobar"
| WHERE message RLIKE ("foo.*", "bar.")
```

Patterns may be specified with REST query placeholders as well
```esql
FROM employees
| WHERE first_name RLIKE ?pattern
| KEEP first_name, last_name
```

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>


### Match operator (`:`)

<applies-to>
  - Elastic Stack: Generally available since 9.1
  - Elastic Stack: Preview in 9.0
</applies-to>

Use the match operator (`:`) to perform full-text search and filter rows that match a given query string.
**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/operators/match_operator.svg)

The match operator performs a [match query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query) on the specified field. Returns true if the provided query matches the row.
The match operator is equivalent to the [match function](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-match), which is the standard function for performing full-text search in ESQL.
For using the function syntax, or adding [match query parameters](/docs/reference/query-languages/query-dsl/query-dsl-match-query#match-field-params), you can use the [match function](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-match).
**Supported types**

| field         | query         | result  |
|---------------|---------------|---------|
| boolean       | boolean       | boolean |
| boolean       | keyword       | boolean |
| date          | date          | boolean |
| date          | keyword       | boolean |
| date_nanos    | date_nanos    | boolean |
| date_nanos    | keyword       | boolean |
| double        | double        | boolean |
| double        | integer       | boolean |
| double        | keyword       | boolean |
| double        | long          | boolean |
| integer       | double        | boolean |
| integer       | integer       | boolean |
| integer       | keyword       | boolean |
| integer       | long          | boolean |
| ip            | ip            | boolean |
| ip            | keyword       | boolean |
| keyword       | keyword       | boolean |
| long          | double        | boolean |
| long          | integer       | boolean |
| long          | keyword       | boolean |
| long          | long          | boolean |
| text          | keyword       | boolean |
| unsigned_long | double        | boolean |
| unsigned_long | integer       | boolean |
| unsigned_long | keyword       | boolean |
| unsigned_long | long          | boolean |
| unsigned_long | unsigned_long | boolean |
| version       | keyword       | boolean |
| version       | version       | boolean |

**Examples**
The match operator can be used to perform full-text search on a `text` field. Notice how the match operator handles multi-valued columns, if a single value matches the query string, the expression evaluates to `TRUE`.
```esql
FROM books
| WHERE author:"Faulkner"
```


| book_no:keyword | author:text                                        |
|-----------------|----------------------------------------------------|
| 2378            | [Carol Faulkner, Holly Byers Ochoa, Lucretia Mott] |
| 2713            | William Faulkner                                   |
| 2847            | Colleen Faulkner                                   |
| 2883            | William Faulkner                                   |
| 3293            | Danny Faulkner                                     |

The match operator can also be used with `keyword` columns to filter multi-values.
```esql
FROM employees
| WHERE job_positions:"Internship"
| KEEP emp_no, job_positions
```


| emp_no:integer | job_positions:keyword                                                     |
|----------------|---------------------------------------------------------------------------|
| 10008          | [Internship, Junior Developer, Purchase Manager, Senior Python Developer] |
| 10009          | [Internship, Senior Python Developer]                                     |
| 10022          | [Data Scientist, Internship, Python Developer, Reporting Analyst]         |

This example illustrates how to do semantic search using the match operator on `semantic_text` fields. By including the metadata field `_score` and sorting on `_score`, we can retrieve the most relevant results in order.
```esql
FROM books METADATA _score
| WHERE semantic_title:"Shakespeare"
| SORT _score DESC
| KEEP _score, semantic_title
```


| _score:double | semantic_text_field:text |
|---------------|--------------------------|
| 9.5770        | Romeo and Juliet         |
| 9.6850        | Hamlet                   |
| 8.232         | Othello                  |