﻿---
title: ES|QL IP functions
description: ES|QL supports these IP functions: 
url: https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/ip-functions
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ES|QL IP functions
ES|QL supports these IP functions:
- [`CIDR_MATCH`](#esql-cidr_match)
- [`IP_PREFIX`](#esql-ip_prefix)


## `CIDR_MATCH`

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/cidr_match.svg)

**Parameters**
<definitions>
  <definition term="ip">
    IP address of type `ip` (both IPv4 and IPv6 are supported).
  </definition>
  <definition term="blockX">
    CIDR block to test the IP against.
  </definition>
</definitions>

**Description**
Returns true if the provided IP is contained in one of the provided CIDR blocks.
**Supported types**

| ip  | blockX  | result  |
|-----|---------|---------|
| ip  | keyword | boolean |
| ip  | text    | boolean |

**Example**
```esql
FROM hosts
| WHERE CIDR_MATCH(ip1, "127.0.0.2/32", "127.0.0.3/32")
| KEEP card, host, ip0, ip1
```


| card:keyword | host:keyword | ip0:ip                    | ip1:ip    |
|--------------|--------------|---------------------------|-----------|
| eth1         | beta         | 127.0.0.1                 | 127.0.0.2 |
| eth0         | gamma        | fe80::cae2:65ff:fece:feb9 | 127.0.0.3 |


## `IP_PREFIX`

**Syntax**
![Embedded](https://www.elastic.co/docs/reference/query-languages/esql/images/functions/ip_prefix.svg)

**Parameters**
<definitions>
  <definition term="ip">
    IP address of type `ip` (both IPv4 and IPv6 are supported).
  </definition>
  <definition term="prefixLengthV4">
    Prefix length for IPv4 addresses.
  </definition>
  <definition term="prefixLengthV6">
    Prefix length for IPv6 addresses.
  </definition>
</definitions>

**Description**
Truncates an IP to a given prefix length.
**Supported types**

| ip  | prefixLengthV4 | prefixLengthV6 | result |
|-----|----------------|----------------|--------|
| ip  | integer        | integer        | ip     |

**Example**
```esql
ROW ip4 = to_ip("1.2.3.4"), ip6 = TO_IP("fe80::cae2:65ff:fece:feb9")
| EVAL ip4_prefix = IP_PREFIX(ip4, 24, 0), ip6_prefix = IP_PREFIX(ip6, 0, 112);
```


| ip4:ip  | ip6:ip                    | ip4_prefix:ip | ip6_prefix:ip             |
|---------|---------------------------|---------------|---------------------------|
| 1.2.3.4 | fe80::cae2:65ff:fece:feb9 | 1.2.3.0       | fe80::cae2:65ff:fece:0000 |