﻿---
title: ES|QL implicit casting
description: Often users will input date, date_period, time_duration, ip or version as simple strings in their queries for use in predicates, functions, or expressions...
url: https://www.elastic.co/docs/reference/query-languages/esql/esql-implicit-casting
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ES|QL implicit casting
Often users will input `date`, `date_period`, `time_duration`, `ip` or `version` as simple strings in their queries for use in predicates, functions, or expressions. ES|QL provides [type conversion functions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/type-conversion-functions) to explicitly convert these strings into the desired data types.
Without implicit casting users must explicitly code these `to_X` functions in their queries, when string literals don’t match the target data types they are assigned or compared to. Here is an example of using `to_datetime` to explicitly perform a data type conversion.
```esql
FROM employees
| EVAL dd_ns1=date_diff("day", to_datetime("2023-12-02T11:00:00.00Z"), birth_date)
| SORT emp_no
| KEEP dd_ns1
| LIMIT 1
```


## Implicit casting example

Implicit casting automatically converts string literals to the target data type. This allows users to specify string values for types like `date`, `date_period`, `time_duration`, `ip` and `version` in their queries.
The first query can be coded without calling the `to_datetime` function, as follows:
```esql
FROM employees
| EVAL dd_ns1=date_diff("day", "2023-12-02T11:00:00.00Z", birth_date)
| SORT emp_no
| KEEP dd_ns1
| LIMIT 1
```


## Operations that support implicit casting

The following table details which ES|QL operations support implicit casting for different data types.

|                           | ScalarFunctions | Operators | [GroupingFunctions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/grouping-functions) | [AggregateFunctions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/aggregation-functions) |
|---------------------------|-----------------|-----------|------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------|
| DATE                      | Y               | Y         | Y                                                                                                                      | N                                                                                                                          |
| DATE_PERIOD/TIME_DURATION | Y               | N         | Y                                                                                                                      | N                                                                                                                          |
| IP                        | Y               | Y         | Y                                                                                                                      | N                                                                                                                          |
| VERSION                   | Y               | Y         | Y                                                                                                                      | N                                                                                                                          |
| BOOLEAN                   | Y               | Y         | Y                                                                                                                      | N                                                                                                                          |

ScalarFunctions includes:
- [Conditional Functions and Expressions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions)
- [Date and Time Functions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/date-time-functions)
- [IP Functions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/ip-functions)

Operators includes:
- [Binary Operators](/docs/reference/query-languages/esql/functions-operators/operators#esql-binary-operators)
- [Unary Operator](/docs/reference/query-languages/esql/functions-operators/operators#esql-unary-operators)
- [IN](/docs/reference/query-languages/esql/functions-operators/operators#esql-in-operator)