﻿---
title: ES|QL functions and operators
description: ES|QL provides a comprehensive set of functions and operators for working with data. The reference documentation is divided into the following categories:...
url: https://www.elastic.co/docs/reference/query-languages/esql/esql-functions-operators
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# ES|QL functions and operators
ES|QL provides a comprehensive set of functions and operators for working with data. The reference documentation is divided into the following categories:

## Functions overview

<dropdown title="Aggregate functions">
  - [`ABSENT`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-absent) <applies-to>Elastic Stack: Generally available since 9.2</applies-to>
  - [`AVG`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-avg)
  - [`COUNT`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-count)
  - [`COUNT_DISTINCT`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-count_distinct)
  - [`MAX`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-max)
  - [`MEDIAN`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-median)
  - [`MEDIAN_ABSOLUTE_DEVIATION`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-median_absolute_deviation)
  - [`MIN`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-min)
  - [`PERCENTILE`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-percentile)
  - [`PRESENT`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-present) <applies-to>Elastic Stack: Generally available since 9.2</applies-to>
  - [`SAMPLE`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-sample)
  - [`ST_CENTROID_AGG`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-st_centroid_agg) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_EXTENT_AGG`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-st_extent_agg) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`STD_DEV`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-std_dev)
  - [`SUM`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-sum)
  - [`TOP`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-top)
  - [`VALUES`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-values) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`VARIANCE`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-variance)
  - [`WEIGHTED_AVG`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-weighted_avg)
  - [`FIRST`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-first)
  - [`LAST`](/docs/reference/query-languages/esql/functions-operators/aggregation-functions#esql-last)
</dropdown>

<dropdown title="Time-series aggregate functions">
  - [`ABSENT_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-absent_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`AVG_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-avg_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`COUNT_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-count_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`COUNT_DISTINCT_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-count_distinct_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`DELTA`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-delta) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`DERIV`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-deriv) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`FIRST_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-first_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`IDELTA`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-idelta) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`INCREASE`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-increase) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`IRATE`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-irate) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`LAST_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-last_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`MAX_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-max_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`MIN_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-min_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`PERCENTILE_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-percentile_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`PRESENT_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-present_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`RATE`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-rate) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`STDDEV_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-stddev_over_time) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`SUM_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-sum_over_time) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`VARIANCE_OVER_TIME`](/docs/reference/query-languages/esql/functions-operators/time-series-aggregation-functions#esql-variance_over_time) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
</dropdown>

<dropdown title="Grouping functions">
  - [`BUCKET`](/docs/reference/query-languages/esql/functions-operators/grouping-functions#esql-bucket)
  - [`TBUCKET`](/docs/reference/query-languages/esql/functions-operators/grouping-functions#esql-tbucket)
  - [`CATEGORIZE`](/docs/reference/query-languages/esql/functions-operators/grouping-functions#esql-categorize)
</dropdown>

<dropdown title="Conditional functions and expressions">
  - [`CASE`](/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions#esql-case)
  - [`COALESCE`](/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions#esql-coalesce)
  - [`GREATEST`](/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions#esql-greatest)
  - [`LEAST`](/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions#esql-least)
  - [`CLAMP`](/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions#esql-clamp) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`CLAMP_MIN`](/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions#esql-clamp_min) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`CLAMP_MAX`](/docs/reference/query-languages/esql/functions-operators/conditional-functions-and-expressions#esql-clamp_max) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
</dropdown>

<dropdown title="Date and time functions">
  - [`DATE_DIFF`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-date_diff)
  - [`DATE_EXTRACT`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-date_extract)
  - [`DATE_FORMAT`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-date_format)
  - [`DATE_PARSE`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-date_parse)
  - [`DATE_TRUNC`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-date_trunc)
  - [`DAY_NAME`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-day_name)
  - [`MONTH_NAME`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-month_name)
  - [`NOW`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-now)
  - [`TRANGE`](/docs/reference/query-languages/esql/functions-operators/date-time-functions#esql-trange)
</dropdown>

<dropdown title="IP functions">
  - [`CIDR_MATCH`](/docs/reference/query-languages/esql/functions-operators/ip-functions#esql-cidr_match)
  - [`IP_PREFIX`](/docs/reference/query-languages/esql/functions-operators/ip-functions#esql-ip_prefix)
</dropdown>

<dropdown title="Math functions">
  - [`ABS`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-abs)
  - [`ACOS`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-acos)
  - [`ACOSH`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-acosh)
  - [`ASIN`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-asin)
  - [`ATAN`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-atan)
  - [`ATAN2`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-atan2)
  - [`CBRT`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-cbrt)
  - [`CEIL`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-ceil)
  - [`COPY_SIGN`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-copy_sign)
  - [`COS`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-cos)
  - [`COSH`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-cosh)
  - [`E`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-e)
  - [`EXP`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-exp)
  - [`FLOOR`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-floor)
  - [`HYPOT`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-hypot)
  - [`LOG`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-log)
  - [`LOG10`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-log10)
  - [`PI`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-pi)
  - [`POW`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-pow)
  - [`ROUND`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-round)
  - [`ROUND_TO`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-round_to)
  - [`SCALB`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-scalb)
  - [`SIGNUM`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-signum)
  - [`SIN`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-sin)
  - [`SINH`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-sinh)
  - [`SQRT`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-sqrt)
  - [`TAN`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-tan)
  - [`TANH`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-tanh)
  - [`TAU`](/docs/reference/query-languages/esql/functions-operators/math-functions#esql-tau)
</dropdown>

<dropdown title="Search functions">
  - [`DECAY`](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-decay) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`KQL`](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-kql)
  - [`MATCH`](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-match)
  - [`MATCH_PHRASE`](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-match_phrase)
  - [`QSTR`](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-qstr)
  - [`SCORE`](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-score) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>

  - [`TOP_SNIPPETS`](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-top_snippets) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
</dropdown>

<dropdown title="Spatial functions">
  - Geospatial predicates
    - [`ST_DISTANCE`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_distance)
  - [`ST_INTERSECTS`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_intersects)
  - [`ST_DISJOINT`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_disjoint)
  - [`ST_CONTAINS`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_contains)
  - [`ST_WITHIN`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_within)
  - Geometry functions
    - [`ST_X`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_x)
  - [`ST_Y`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_y)
  - [`ST_NPOINTS`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_npoints) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_SIMPLIFY`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_simplify) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_ENVELOPE`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_envelope) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
    - [`ST_XMAX`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_xmax) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_XMIN`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_xmin) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_YMAX`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_ymax) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_YMIN`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_ymin) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - Grid encoding functions
    - [`ST_GEOTILE`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_geotile) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_GEOHEX`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_geohex) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`ST_GEOHASH`](/docs/reference/query-languages/esql/functions-operators/spatial-functions#esql-st_geohash) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
</dropdown>

<dropdown title="String functions">
  - [`BIT_LENGTH`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-bit_length)
  - [`BYTE_LENGTH`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-byte_length)
  - [`CHUNK`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-chunk)
  - [`CONCAT`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-concat)
  - [`CONTAINS`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-contains)
  - [`ENDS_WITH`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-ends_with)
  - [`FROM_BASE64`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-from_base64)
  - [`HASH`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-hash)
  - [`LEFT`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-left)
  - [`LENGTH`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-length)
  - [`LOCATE`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-locate)
  - [`LTRIM`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-ltrim)
  - [`MD5`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-md5)
  - [`REPEAT`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-repeat)
  - [`REPLACE`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-replace)
  - [`REVERSE`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-reverse)
  - [`RIGHT`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-right)
  - [`RTRIM`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-rtrim)
  - [`SHA1`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-sha1)
  - [`SHA256`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-sha256)
  - [`SPACE`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-space)
  - [`SPLIT`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-split)
  - [`STARTS_WITH`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-starts_with)
  - [`SUBSTRING`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-substring)
  - [`TO_BASE64`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-to_base64)
  - [`TO_LOWER`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-to_lower)
  - [`TO_UPPER`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-to_upper)
  - [`TRIM`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-trim)
  - [`URL_ENCODE`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-url_encode)
  - [`URL_ENCODE_COMPONENT`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-url_encode_component)
  - [`URL_DECODE`](/docs/reference/query-languages/esql/functions-operators/string-functions#esql-url_decode)
</dropdown>

<dropdown title="Type conversion functions">
  - [`TO_AGGREGATE_METRIC_DOUBLE`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_aggregate_metric_double) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`TO_BOOLEAN`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_boolean)
  - [`TO_CARTESIANPOINT`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_cartesianpoint)
  - [`TO_CARTESIANSHAPE`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_cartesianshape)
  - [`TO_DATEPERIOD`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_dateperiod)
  - [`TO_DATETIME`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_datetime)
  - [`TO_DATE_NANOS`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_date_nanos)
  - [`TO_DEGREES`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_degrees)
  - [`TO_DENSE_VECTOR`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_dense_vector) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`TO_DOUBLE`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_double)
  - [`TO_GEOHASH`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_geohash) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`TO_GEOHEX`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_geohex) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`TO_GEOPOINT`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_geopoint)
  - [`TO_GEOSHAPE`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_geoshape)
  - [`TO_GEOTILE`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_geotile) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`TO_INTEGER`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_integer)
  - [`TO_IP`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_ip)
  - [`TO_LONG`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_long)
  - [`TO_RADIANS`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_radians)
  - [`TO_STRING`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_string)
  - [`TO_TIMEDURATION`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_timeduration)
  - [`TO_UNSIGNED_LONG`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_unsigned_long) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`TO_VERSION`](/docs/reference/query-languages/esql/functions-operators/type-conversion-functions#esql-to_version)
</dropdown>

<dropdown title="Dense vector functions">
  - [`KNN`](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-knn) <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`TEXT_EMBEDDING`](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-text_embedding) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`V_COSINE`](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-v_cosine) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`V_DOT_PRODUCT`](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-v_dot_product) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`V_HAMMING`](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-v_hamming) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`V_L1_NORM`](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-v_l1_norm) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`V_L2_NORM`](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-v_l2_norm) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
</dropdown>

<dropdown title="Multi value functions">
  - [`MV_APPEND`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_append)
  - [`MV_AVG`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_avg)
  - [`MV_CONCAT`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_concat)
  - [`MV_CONTAINS`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_contains) <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`MV_COUNT`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_count)
  - [`MV_DEDUPE`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_dedupe)
  - [`MV_FIRST`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_first)
  - [`MV_INTERSECTION`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_intersection) <applies-to>Elastic Stack: Preview since 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`MV_INTERSECTS`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_intersects) <applies-to>Elastic Stack: Planned</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`MV_LAST`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_last)
  - [`MV_MAX`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_max)
  - [`MV_MEDIAN`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_median)
  - [`MV_MEDIAN_ABSOLUTE_DEVIATION`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_median_absolute_deviation)
  - [`MV_MIN`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_min)
  - [`MV_PERCENTILE`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_percentile)
  - [`MV_PSERIES_WEIGHTED_SUM`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_pseries_weighted_sum)
  - [`MV_SORT`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_sort)
  - [`MV_SLICE`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_slice)
  - [`MV_SUM`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_sum)
  - [`MV_UNION`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_union) <applies-to>Elastic Stack: Planned</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
  - [`MV_ZIP`](/docs/reference/query-languages/esql/functions-operators/mv-functions#esql-mv_zip)
</dropdown>


## Operators overview

<dropdown title="Operators">
  - [Binary operators](/docs/reference/query-languages/esql/functions-operators/operators#esql-binary-operators)
  - [Unary operators](/docs/reference/query-languages/esql/functions-operators/operators#esql-unary-operators)
  - [Logical operators](/docs/reference/query-languages/esql/functions-operators/operators#esql-logical-operators)
  - [suffix operators](/docs/reference/query-languages/esql/functions-operators/operators#esql-suffix-operators)
  - [infix operators](/docs/reference/query-languages/esql/functions-operators/operators#esql-infix-operators)
</dropdown>