﻿---
title: ES|QL SET directive
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/set
products:
  - Elasticsearch
---

# ES|QL SET directive
<applies-to>
  - Elastic Cloud Serverless: Preview since 9.3
</applies-to>

The `SET` directive can be used to specify query settings that modify the behavior of an ES|QL query.
**Syntax**
```esql
SET setting_name = setting_value[, ..., settingN = valueN]; <query>
```

Multiple SET directives can be included in a single query, separated by semicolons.
If the same setting is defined multiple times, the last definition takes precedence.
**Allowed settings**

### `time_zone`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Planned
</applies-to>

The default timezone to be used in the query. Defaults to UTC, and overrides the `time_zone` request parameter. See [timezones](/docs/reference/query-languages/esql/esql-rest#esql-timezones).
**Type**: `keyword`
**Example**
```esql
SET time_zone = "+05:00";
TS k8s
| WHERE @timestamp == "2024-05-10T00:04:49.000Z"
| STATS by @timestamp, bucket = TBUCKET(3 hours)
| SORT @timestamp
| LIMIT 2
```


### `unmapped_fields`

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
</applies-to>

Defines how unmapped fields are treated. Possible values are: "FAIL" (default) - fails the query if unmapped fields are present; "NULLIFY" - treats unmapped fields as null values.
**Type**: `keyword`
**Example**
Make the field null if it is unmapped.
```esql
SET unmapped_fields="nullify";
FROM employees
| KEEP emp_*, foo
| SORT emp_no
| LIMIT 1
```


| emp_no:integer | foo:null |
|----------------|----------|
| 10001          | null     |