﻿---
title: ES|QL RENAME command
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/rename
products:
  - Elasticsearch
---

# ES|QL RENAME command
<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
</applies-to>

The `RENAME` processing command renames one or more columns.
**Syntax**
```esql
RENAME old_name1 AS new_name1[, ..., old_nameN AS new_nameN]
```

The following syntax is also supported <applies-to>Elastic Stack: Generally available since 9.1</applies-to>:
```esql
RENAME new_name1 = old_name1[, ..., new_nameN = old_nameN]
```

<tip>
  Both syntax options can be used interchangeably but we recommend sticking to one for consistency and readability.
</tip>

**Parameters**
<definitions>
  <definition term="old_nameX">
    The name of a column you want to rename.
  </definition>
  <definition term="new_nameX">
    The new name of the column. If it conflicts with an existing column name,
    the existing column is dropped. If multiple columns are renamed to the same
    name, all but the rightmost column with the same new name are dropped.
  </definition>
</definitions>

**Description**
The `RENAME` processing command renames one or more columns. If a column with
the new name already exists, it will be replaced by the new column.
A `RENAME` with multiple column renames is equivalent to multiple sequential `RENAME` commands.
**Examples**
```esql
FROM employees
| KEEP first_name, last_name, still_hired
| RENAME  still_hired AS employed
```

Multiple columns can be renamed with a single `RENAME` command:
```esql
FROM employees
| KEEP first_name, last_name
| RENAME first_name AS fn, last_name AS ln
```

With multiple `RENAME` commands:
```esql
FROM employees
| KEEP first_name, last_name
| RENAME first_name AS fn
| RENAME last_name AS ln
```