﻿---
title: ES|QL MV_EXPAND command
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/mv_expand
products:
  - Elasticsearch
---

# ES|QL MV_EXPAND command
<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview
</applies-to>

The `MV_EXPAND` processing command expands multivalued columns into one row per
value, duplicating other columns.
**Syntax**
```esql
MV_EXPAND column
```

**Parameters**
<definitions>
  <definition term="column">
    The multivalued column to expand.
  </definition>
</definitions>

<warning>
  The output rows produced by `MV_EXPAND` can be in any order and may not respect
  preceding `SORT`s. To guarantee a certain ordering, place a `SORT` after any
  `MV_EXPAND`s.
</warning>

**Example**
```esql
ROW a=[1,2,3], b="b", j=["a","b"]
| MV_EXPAND a
```


| a:integer | b:keyword | j:keyword  |
|-----------|-----------|------------|
| 1         | b         | ["a", "b"] |
| 2         | b         | ["a", "b"] |
| 3         | b         | ["a", "b"] |