﻿---
title: ES|QL FROM command
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/from
products:
  - Elasticsearch
---

# ES|QL FROM command
<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
</applies-to>

The `FROM` source command returns a table with data from a data stream, index,
or alias.
**Syntax**
```esql
FROM index_pattern [METADATA fields]
```

**Parameters**
<definitions>
  <definition term="index_pattern">
    A list of indices, data streams or aliases. Supports wildcards and date math.
  </definition>
  <definition term="fields">
    A comma-separated list of [metadata fields](https://www.elastic.co/docs/reference/query-languages/esql/esql-metadata-fields) to retrieve.
  </definition>
</definitions>

**Description**
The `FROM` source command returns a table with data from a data stream, index,
or alias. Each row in the resulting table represents a document. Each column
corresponds to a field, and can be accessed by the name of that field.
<note>
  By default, an ES|QL query without an explicit [`LIMIT`](#esql-limit) uses an implicit
  limit of 1000. This applies to `FROM` too. A `FROM` command without `LIMIT`:
  ```esql
  FROM employees
  ```
  is executed as:
  ```esql
  FROM employees
  | LIMIT 1000
  ```
</note>

**Examples**
```esql
FROM employees
```

You can use [date math](/docs/reference/elasticsearch/rest-apis/api-conventions#api-date-math-index-names) to refer to indices, aliases
and data streams. This can be useful for time series data, for example to access
today’s index:
```esql
FROM <logs-{now/d}>
```

Use comma-separated lists or wildcards to
[query multiple data streams, indices, or aliases](https://www.elastic.co/docs/reference/query-languages/esql/esql-multi-index):
```esql
FROM employees-00001,other-employees-*
```

Use the format `<remote_cluster_name>:<target>` to
[query data streams and indices on remote clusters](https://www.elastic.co/docs/reference/query-languages/esql/esql-cross-clusters):
```esql
FROM cluster_one:employees-00001,cluster_two:other-employees-*
```

Use the optional `METADATA` directive to enable
[metadata fields](https://www.elastic.co/docs/reference/query-languages/esql/esql-metadata-fields):
```esql
FROM employees METADATA _id
```

Use enclosing double quotes (`"`) or three enclosing double quotes (`"""`) to escape index names
that contain special characters:
```esql
FROM "this=that", """this[that"""
```