﻿---
title: ES|QL FORK command
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/fork
products:
  - Elasticsearch
---

# ES|QL FORK command
<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.1
</applies-to>

The `FORK` processing command creates multiple execution branches to operate
on the same input data and combines the results in a single output table.
**Syntax**
```esql
FORK ( <processing_commands> ) ( <processing_commands> ) ... ( <processing_commands> )
```

**Description**
The `FORK` processing command creates multiple execution branches to operate
on the same input data and combines the results in a single output table. A discriminator column (`_fork`) is added to identify which branch each row came from.
Together with the [`FUSE`](https://www.elastic.co/docs/reference/query-languages/esql/commands/fuse) command, `FORK` enables hybrid search to combine and score results from multiple queries. To learn more about using ES|QL for search, refer to [ES|QL for search](https://www.elastic.co/docs/solutions/search/esql-for-search).
**Branch identification:**
- The `_fork` column identifies each branch with values like `fork1`, `fork2`, `fork3`
- Values correspond to the order branches are defined
- `fork1` always indicates the first branch

**Column handling:**
- `FORK` branches can output different columns
- Columns with the same name must have the same data type across all branches
- Missing columns are filled with `null` values

**Row ordering:**
- `FORK` preserves row order within each branch
- Rows from different branches may be interleaved
- Use `SORT _fork` to group results by branch

<note>
  `FORK` branches default to `LIMIT 1000` if no `LIMIT` is provided.
</note>

**Limitations**
- `FORK` supports at most 8 execution branches.
- In versions older than 9.3.0 using remote cluster references and `FORK` is not supported.
- Using more than one `FORK` command in a query is not supported.

**Examples**
In the following example, each `FORK` branch returns one row.
Notice how `FORK` adds a `_fork` column that indicates which row the branch originates from:
```esql
FROM employees
| FORK ( WHERE emp_no == 10001 )
       ( WHERE emp_no == 10002 )
| KEEP emp_no, _fork
| SORT emp_no
```


| emp_no:integer | _fork:keyword |
|----------------|---------------|
| 10001          | fork1         |
| 10002          | fork2         |