﻿---
title: ES|QL ENRICH command
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/enrich
products:
  - Elasticsearch
---

# ES|QL ENRICH command
<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
</applies-to>

`ENRICH` enables you to add data from existing indices as new columns using an
enrich policy.
**Syntax**
```esql
ENRICH policy [ON match_field] [WITH [new_name1 = ]field1, [new_name2 = ]field2, ...]
```

**Parameters**
<definitions>
  <definition term="policy">
    The name of the enrich policy.
    You need to [create](/docs/reference/query-languages/esql/esql-enrich-data#esql-set-up-enrich-policy)
    and [execute](/docs/reference/query-languages/esql/esql-enrich-data#esql-execute-enrich-policy)
    the enrich policy first.
  </definition>
  <definition term="mode">
    The mode of the enrich command in cross cluster ES|QL.
    See [enrich across clusters](/docs/reference/query-languages/esql/esql-cross-clusters#ccq-enrich).
  </definition>
  <definition term="match_field">
    The match field. `ENRICH` uses its value to look for records in the enrich
    index. If not specified, the match will be performed on the column with the same
    name as the `match_field` defined in the [enrich policy](/docs/reference/query-languages/esql/esql-enrich-data#esql-enrich-policy).
  </definition>
  <definition term="fieldX">
    The enrich fields from the enrich index that are added to the result as new
    columns. If a column with the same name as the enrich field already exists, the
    existing column will be replaced by the new column. If not specified, each of
    the enrich fields defined in the policy is added.
    A column with the same name as the enrich field will be dropped unless the
    enrich field is renamed.
  </definition>
  <definition term="new_nameX">
    Enables you to change the name of the column that’s added for each of the enrich
    fields. Defaults to the enrich field name.
    If a column has the same name as the new name, it will be discarded.
    If a name (new or original) occurs more than once, only the rightmost duplicate
    creates a new column.
  </definition>
</definitions>

**Description**
`ENRICH` enables you to add data from existing indices as new columns using an
enrich policy. Refer to [Data enrichment](https://www.elastic.co/docs/reference/query-languages/esql/esql-enrich-data)
for information about setting up a policy.
![esql enrich](https://www.elastic.co/docs/reference/query-languages/images/esql-enrich.png)

<tip>
  Before you can use `ENRICH`, you need to [create and execute an enrich policy](/docs/reference/query-languages/esql/esql-enrich-data#esql-set-up-enrich-policy).
</tip>

**Examples**
The following example uses the `languages_policy` enrich policy to add a new
column for each enrich field defined in the policy. The match is performed using
the `match_field` defined in the [enrich policy](/docs/reference/query-languages/esql/esql-enrich-data#esql-enrich-policy) and
requires that the input table has a column with the same name (`language_code`
in this example). `ENRICH` will look for records in th
[enrich index](/docs/reference/query-languages/esql/esql-enrich-data#esql-enrich-index)
based on the match field value.
```esql
ROW language_code = "1"
| ENRICH languages_policy
```


| language_code:keyword | language_name:keyword |
|-----------------------|-----------------------|
| 1                     | English               |

To use a column with a different name than the `match_field` defined in the
policy as the match field, use `ON <column-name>`:
```esql
ROW a = "1"
| ENRICH languages_policy ON a
```


| a:keyword | language_name:keyword |
|-----------|-----------------------|
| 1         | English               |

By default, each of the enrich fields defined in the policy is added as a
column. To explicitly select the enrich fields that are added, use
`WITH <field1>, <field2>, ...`:
```esql
ROW a = "1"
| ENRICH languages_policy ON a WITH language_name
```


| a:keyword | language_name:keyword |
|-----------|-----------------------|
| 1         | English               |

You can rename the columns that are added using `WITH new_name=<field1>`:
```esql
ROW a = "1"
| ENRICH languages_policy ON a WITH name = language_name
```


| a:keyword | name:keyword |
|-----------|--------------|
| 1         | English      |

In case of name collisions, the newly created columns will override existing
columns.