﻿---
title: ES|QL DISSECT command
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/dissect
products:
  - Elasticsearch
---

# ES|QL DISSECT command
<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
</applies-to>

`DISSECT` enables you to [extract structured data out of a string](https://www.elastic.co/docs/reference/query-languages/esql/esql-process-data-with-dissect-grok).
**Syntax**
```esql
DISSECT input "pattern" [APPEND_SEPARATOR="<separator>"]
```

**Parameters**
<definitions>
  <definition term="input">
    The column that contains the string you want to structure.  If the column has
    multiple values, `DISSECT` will process each value.
  </definition>
  <definition term="pattern">
    A [dissect pattern](/docs/reference/query-languages/esql/esql-process-data-with-dissect-grok#esql-dissect-patterns).
    If a field name conflicts with an existing column, the existing column is dropped.
    If a field name is used more than once, only the rightmost duplicate creates a column.
  </definition>
  <definition term="<separator>">
    A string used as the separator between appended values, when using the [append modifier](/docs/reference/query-languages/esql/esql-process-data-with-dissect-grok#esql-append-modifier).
  </definition>
</definitions>

**Description**
`DISSECT` enables you to [extract structured data out of a string](https://www.elastic.co/docs/reference/query-languages/esql/esql-process-data-with-dissect-grok).
`DISSECT` matches the string against a delimiter-based pattern, and extracts the specified keys as columns.
Refer to [Process data with `DISSECT`](/docs/reference/query-languages/esql/esql-process-data-with-dissect-grok#esql-process-data-with-dissect) for the syntax of dissect patterns.
**Examples**
The following example parses a string that contains a timestamp, some text, and
an IP address:
```esql
ROW a = "2023-01-23T12:15:00.000Z - some text - 127.0.0.1"
| DISSECT a """%{date} - %{msg} - %{ip}"""
| KEEP date, msg, ip
```


| date:keyword             | msg:keyword | ip:keyword |
|--------------------------|-------------|------------|
| 2023-01-23T12:15:00.000Z | some text   | 127.0.0.1  |

By default, `DISSECT` outputs keyword string columns. To convert to another
type, use [Type conversion functions](https://www.elastic.co/docs/reference/query-languages/esql/functions-operators/type-conversion-functions):
```esql
ROW a = "2023-01-23T12:15:00.000Z - some text - 127.0.0.1"
| DISSECT a """%{date} - %{msg} - %{ip}"""
| KEEP date, msg, ip
| EVAL date = TO_DATETIME(date)
```


| msg:keyword | ip:keyword | date:date                |
|-------------|------------|--------------------------|
| some text   | 127.0.0.1  | 2023-01-23T12:15:00.000Z |