﻿---
title: ES|QL CHANGE_POINT command
description: 
url: https://www.elastic.co/docs/reference/query-languages/esql/commands/change-point
products:
  - Elasticsearch
---

# ES|QL CHANGE_POINT command
<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
  - Elastic Stack: Preview in 9.1
</applies-to>

<note>
  The `CHANGE_POINT` command requires a [platinum license](https://www.elastic.co/subscriptions).
</note>

`CHANGE_POINT` detects spikes, dips, and change points in a metric.
**Syntax**
```esql
CHANGE_POINT value [ON key] [AS type_name, pvalue_name]
```

**Parameters**
<definitions>
  <definition term="value">
    The column with the metric in which you want to detect a change point.
  </definition>
  <definition term="key">
    The column with the key to order the values by. If not specified, `@timestamp` is used.
  </definition>
  <definition term="type_name">
    The name of the output column with the change point type. If not specified, `type` is used.
  </definition>
  <definition term="pvalue_name">
    The name of the output column with the p-value that indicates how extreme the change point is. If not specified, `pvalue` is used.
  </definition>
</definitions>

**Description**
`CHANGE_POINT` detects spikes, dips, and change points in a metric. The command adds columns to
the table with the change point type and p-value, that indicates how extreme the change point is
(lower values indicate greater changes).
The possible change point types are:
- `dip`: a significant dip occurs at this change point
- `distribution_change`: the overall distribution of the values has changed significantly
- `spike`: a significant spike occurs at this point
- `step_change`: the change indicates a statistically significant step up or down in value distribution
- `trend_change`: there is an overall trend change occurring at this point

<note>
  There must be at least 22 values for change point detection. Fewer than 1,000 is preferred.
</note>

**Examples**
The following example shows the detection of a step change:
```esql
ROW key=[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25]
| MV_EXPAND key
| EVAL value = CASE(key<13, 0, 42)
| CHANGE_POINT value ON key
| WHERE type IS NOT NULL
```


| key:integer | value:integer | type:keyword | pvalue:double |
|-------------|---------------|--------------|---------------|
| 13          | 42            | step_change  | 0.0           |