% This is generated by ESQL's AbstractFunctionTestCase. Do not edit it. See ../README.md for how to regenerate it.

**Examples**

The match operator can be used to perform full-text search on a `text` field. Notice how the match operator handles multi-valued columns, if a single value matches the query string, the expression evaluates to `TRUE`.

```esql
FROM books
| WHERE author:"Faulkner"
```

| book_no:keyword | author:text |
| --- | --- |
| 2378 | [Carol Faulkner, Holly Byers Ochoa, Lucretia Mott] |
| 2713 | William Faulkner |
| 2847 | Colleen Faulkner |
| 2883 | William Faulkner |
| 3293 | Danny Faulkner |

The match operator can also be used with `keyword` columns to filter multi-values.

```esql
FROM employees
| WHERE job_positions:"Internship"
| KEEP emp_no, job_positions
```

| emp_no:integer | job_positions:keyword |
| --- | --- |
| 10008 | [Internship, Junior Developer, Purchase Manager, Senior Python Developer] |
| 10009 | [Internship, Senior Python Developer] |
| 10022 | [Data Scientist, Internship, Python Developer, Reporting Analyst] |

This example illustrates how to do semantic search using the match operator on `semantic_text` fields. By including the metadata field `_score` and sorting on `_score`, we can retrieve the most relevant results in order.

```esql
FROM books METADATA _score
| WHERE semantic_title:"Shakespeare"
| SORT _score DESC
| KEEP _score, semantic_title
```

| _score:double | semantic_text_field:text |
| --- | --- |
| 9.5770 | Romeo and Juliet |
| 9.6850 | Hamlet |
| 8.232 | Othello |


