% This is generated by ESQL's AbstractFunctionTestCase. Do not edit it. See ../README.md for how to regenerate it.

When used on `text` fields, `LIKE` treats the field as a `keyword` and does not use the analyzer.
This means the pattern matching is case-sensitive and must match the exact string indexed.
To perform full-text search, use the `MATCH` or `QSTR` functions.

Matching the exact characters `*` and `.` will require escaping.
The escape character is backslash `\`. Since also backslash is a special character in string literals,
it will require further escaping.

```esql
ROW message = "foo * bar"
| WHERE message LIKE "foo \\* bar"
```


To reduce the overhead of escaping, we suggest using triple quotes strings `"""`

```esql
ROW message = "foo * bar"
| WHERE message LIKE """foo \* bar"""
```


```{applies_to}
stack: ga 9.1
serverless: ga
```
Both a single pattern or a list of patterns are supported. If a list of patterns is provided,
the expression will return true if any of the patterns match.

```esql
ROW message = "foobar"
| WHERE message like ("foo*", "bar?")
```


Patterns may be specified with REST query placeholders as well

```esql
FROM employees
| WHERE first_name LIKE ?pattern
| KEEP first_name, last_name
```

```{applies_to}
stack: ga 9.3
```

