% This is generated by ESQL's AbstractFunctionTestCase. Do not edit it. See ../README.md for how to regenerate it.

**Examples**

```esql
ROW long = [5013792, 2147483647, 501379200000]
| EVAL int = TO_INTEGER(long)
```

| long:long | int:integer |
| --- | --- |
| [5013792, 2147483647, 501379200000] | [5013792, 2147483647] |


Note that in this example, the last value of the multi-valued field cannot be converted as an integer.
When this happens, the result is a `null` value. In this case a _Warning_ header is added to the response.
The header will provide information on the source of the failure:

`"Line 1:61: evaluation of [TO_INTEGER(long)] failed, treating result as null. Only first 20 failures recorded."`

A following header will contain the failure reason and the offending value:

`"org.elasticsearch.xpack.esql.core.InvalidArgumentException: [501379200000] out of [integer] range"`

```esql
ROW str1 = "0x32", str2 = "31"
| EVAL int1 = TO_INTEGER(str1, 16), int2 = TO_INTEGER(str2, 13)
| KEEP str1, int1, str2, int2
```

| str1:keyword | int1:integer | str2:keyword | int2:integer |
| --- | --- | --- | --- |
| 0x32 | 50 | 31 | 40 |


This example demonstrates parsing a base 16 value and a base 13 value. {applies_to}`stack: ga 9.3`

```esql
ROW str1 = "Kona"
| EVAL int1 = TO_INTEGER(str1, 27), fail1 = TO_INTEGER(str1, 10)
```

| str1:keyword | int1:integer | fail1:integer |
| --- | --- | --- |
| Kona | 411787 | null |


This example demonstrates parsing a string that is valid in base 27 but invalid in base 10.Observe in the second case a warning is generated and null is returned. {applies_to}`stack: ga 9.3`


