% This is generated by ESQL's AbstractFunctionTestCase. Do not edit it. See ../README.md for how to regenerate it.

**Examples**

Provide a bucket size as an argument.

```esql
FROM sample_data
| STATS min = MIN(@timestamp), max = MAX(@timestamp) BY bucket = TBUCKET(1 hour)
| SORT min
```

| min:datetime | max:datetime | bucket:datetime |
| --- | --- | --- |
| 2023-10-23T12:15:03.360Z | 2023-10-23T12:27:28.948Z | 2023-10-23T12:00:00.000Z |
| 2023-10-23T13:33:34.937Z | 2023-10-23T13:55:01.543Z | 2023-10-23T13:00:00.000Z |


::::{note}
When providing the bucket size, it must be a time duration or date period.
Also the reference is epoch, which starts at `0001-01-01T00:00:00Z`.
::::

Provide a string representation of bucket size as an argument.

```esql
FROM sample_data
| STATS min = MIN(@timestamp), max = MAX(@timestamp) BY bucket = TBUCKET("1 hour")
| SORT min
```

| min:datetime | max:datetime | bucket:datetime |
| --- | --- | --- |
| 2023-10-23T12:15:03.360Z | 2023-10-23T12:27:28.948Z | 2023-10-23T12:00:00.000Z |
| 2023-10-23T13:33:34.937Z | 2023-10-23T13:55:01.543Z | 2023-10-23T13:00:00.000Z |


::::{note}
When providing the bucket size, it can be a string representation of time duration or date period.
For example, "1 hour". Also the reference is epoch, which starts at `0001-01-01T00:00:00Z`.
::::


