﻿---
title: EQL pipe reference
description: Elasticsearch supports the following EQL pipes. Returns up to a specified number of events or sequences, starting with the earliest matches. Works similarly...
url: https://www.elastic.co/docs/reference/query-languages/eql/eql-pipe-ref
products:
  - Elasticsearch
---

# EQL pipe reference
Elasticsearch supports the following [EQL pipes](/docs/reference/query-languages/eql/eql-syntax#eql-pipes).

## `head`

Returns up to a specified number of events or sequences, starting with the earliest matches. Works similarly to the [Unix head command](https://en.wikipedia.org/wiki/Head_(Unix)).
**Example**
The following EQL query returns up to three of the earliest powershell commands.
```eql
process where process.name == "powershell.exe"
| head 3
```

**Syntax**
```txt
head <max>
```

**Parameters**
<definitions>
  <definition term="<max>">
    (Required, integer) Maximum number of matching events or sequences to return.
  </definition>
</definitions>


## `tail`

Returns up to a specified number of events or sequences, starting with the most recent matches. Works similarly to the [Unix tail command](https://en.wikipedia.org/wiki/Tail_(Unix)).
**Example**
The following EQL query returns up to five of the most recent `svchost.exe` processes.
```eql
process where process.name == "svchost.exe"
| tail 5
```

**Syntax**
```txt
tail <max>
```

**Parameters**
<definitions>
  <definition term="<max>">
    (Required, integer) Maximum number of matching events or sequences to return.
  </definition>
</definitions>