﻿---
title: Elastic Cloud Managed OTLP Endpoint (mOTLP)
description: Reference documentation for the Elastic Cloud Managed OTLP Endpoint.
url: https://www.elastic.co/docs/reference/opentelemetry/motlp
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Collector
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Cloud Hosted: Preview
  - Self-managed Elastic deployments: Unavailable
---

# Elastic Cloud Managed OTLP Endpoint (mOTLP)
The Elastic Cloud Managed OTLP Endpoint allows you to send OpenTelemetry data directly to Elastic Cloud using the OTLP protocol. The endpoint adds a resilient ingestion layer that works seamlessly with serverless autoscaling and removes pressure from Elastic Cloud Hosted clusters.
<important>
  The Elastic Cloud Managed OTLP Endpoint endpoint is not available for Elastic [self-managed](https://www.elastic.co/docs/deploy-manage/deploy/self-managed), [ECE](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise) or [ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s) clusters. To send OTLP data to any of these cluster types, deploy and expose an OTLP-compatible endpoint using the EDOT Collector as a gateway. Refer to [EDOT deployment docs](https://www.elastic.co/docs/reference/edot-collector/modes#edot-collector-as-gateway) for more information.
</important>


## Reference architecture

This diagram shows data ingest using Elastic Distribution of OpenTelemetry and the Elastic Cloud Managed OTLP Endpoint:
![mOTLP Reference architecture](https://www.elastic.co/docs/reference/opentelemetry/images/motlp-reference-architecture.png)

Telemetry is stored in Elastic in OTLP format, preserving resource attributes and original semantic conventions. If no specific dataset or namespace is provided, the data streams are: `traces-generic.otel-default`, `metrics-generic.otel-default`, and `logs-generic.otel-default`.
For a detailed comparison of how OTel data streams differ from classic Elastic APM data streams, refer to [OTel data streams compared to classic APM](https://www.elastic.co/docs/reference/opentelemetry/compatibility/data-streams).

## Prerequisites

To use the Elastic Cloud Elastic Cloud Managed OTLP Endpoint you need the following:
- An Elastic Cloud Serverless project or an Elastic Cloud Hosted (ECH) deployment.
- An OTLP-compliant shipper capable of forwarding logs, metrics, or traces in OTLP format. This can include:
  - [OpenTelemetry Collector](https://www.elastic.co/docs/reference/edot-collector) (EDOT, Contrib, or other distributions)
- [OpenTelemetry SDKs](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks) (EDOT, upstream, or other distributions)
- [EDOT Cloud Forwarder](https://www.elastic.co/docs/reference/opentelemetry/edot-cloud-forwarder)
- Any other forwarder that supports the OTLP protocol.

You don't need APM Server when ingesting data through the Managed OTLP Endpoint. The APM integration (`.apm` endpoint) is a legacy ingest path that only supports traces and translates OTLP telemetry to ECS, whereas Elastic Cloud Managed OTLP Endpoint natively ingests OTLP data.
<note>
  For Elastic Cloud Hosted deployments, Elastic Cloud Managed OTLP Endpoint is currently supported in the following AWS regions: ap-southeast-1, ap-northeast-1, ap-south-1, eu-west-1, eu-west-2, us-east-1, us-west-2, us-east-2.
  Support for additional regions and cloud providers is in progress and will be expanded over time.
</note>


## Send data to Elastic

To send data to Elastic through the Elastic Cloud Managed OTLP Endpoint, follow the [Send data to the Elastic Cloud Managed OTLP Endpoint](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-elastic-cloud-otel-endpoint) quickstart.

### Find your Elastic Cloud Managed OTLP Endpoint endpoint

To retrieve your Elastic Cloud Managed OTLP Endpoint endpoint address and API key, follow these steps:
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. In Elastic Cloud, create an Observability project or open an existing one.
    2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
    3. Copy the endpoint and authentication headers values.
    Alternatively, you can retrieve the endpoint from the **Manage project** page and create an API key manually from the **API keys** page.
  </applies-item>

  <applies-item title="ess: preview" applies-to="Elastic Cloud Hosted: Preview">
    You need an Elastic Cloud Hosted deployment version 9.2 or later.
    1. In Elastic Cloud, create an Elastic Cloud Hosted deployment or open an existing one.
    2. Go to **Add data**, select **Applications** and then select **OpenTelemetry**.
    3. Copy the endpoint and authentication headers values.
  </applies-item>
</applies-switch>


### Configure SDKs to send data directly

To configure OpenTelemetry SDKs to send data directly to the Elastic Cloud Managed OTLP Endpoint, set the `OTEL_EXPORTER_OTLP_ENDPOINT` and `OTEL_EXPORTER_OTLP_HEADERS` environment variable.
For example:
```bash
export OTEL_EXPORTER_OTLP_ENDPOINT="https://<motlp-endpoint>"
export OTEL_EXPORTER_OTLP_HEADERS="Authorization=ApiKey <key>"
```


## Routing logs to dedicated datasets

You can route logs to dedicated datasets by setting the `data_stream.dataset` attribute to the log record. This attribute is used to route the log to the corresponding dataset.
For example, if you want to route the EDOT Cloud Forwarder logs to custom datasets, you can add the following attributes to the log records:
```yaml
processors:
  transform:
    log_statements:
      - set(log.attributes["data_stream.dataset"], "aws.cloudtrail") where log.attributes["aws.cloudtrail.event_id"] != nil
```

You can also set the `OTEL_RESOURCE_ATTRIBUTES` environment variable to set the `data_stream.dataset` attribute for all logs. For example:
```bash
export OTEL_RESOURCE_ATTRIBUTES="data_stream.dataset=app.orders"
```


## Failure store

The Elastic Cloud Managed OTLP Endpoint endpoint is designed to be highly available and resilient. However, there are some scenarios where data might be lost or not sent completely. The [Failure store](https://www.elastic.co/docs/manage-data/data-store/data-streams/failure-store) is a mechanism that allows you to recover from these scenarios.
The Failure store is always enabled for Elastic Cloud Managed OTLP Endpoint data streams. This prevents ingest pipeline exceptions and conflicts with data stream mappings. Failed documents are stored in a separate index. You can view the failed documents from the **Data Set Quality** page. Refer to [Data set quality](https://www.elastic.co/docs/solutions/observability/data-set-quality-monitoring).

## Limitations

The following limitations apply when using the Elastic Cloud Managed OTLP Endpoint:
- Tail-based sampling (TBS) is not available.
- Universal Profiling is not available.
- Only supports histograms with delta temporality. Cumulative histograms are dropped.
- Latency distributions based on histogram values have limited precision due to the fixed boundaries of explicit bucket histograms.
- [Traffic filters](https://www.elastic.co/docs/deploy-manage/security/ip-filtering-cloud) are not yet available on both ECH and Serverless


## Billing

For more information on billing, refer to [Elastic Cloud pricing](https://www.elastic.co/pricing/serverless-observability).

## Rate limiting

Requests to the Elastic Cloud Managed OTLP Endpoint are subject to rate limiting and throttling. If you send data at a rate that exceeds the limits, your requests might be rejected.
The following rate limits and burst limits apply:

| Deployment type | Rate limit       | Burst limit      | Dynamic scaling |
|-----------------|------------------|------------------|-----------------|
| Serverless      | 30 MB/s          | 60 MB/s          | Not available   |
| ECH             | 1 MB/s (initial) | 2 MB/s (initial) | Yes             |

As long as your data ingestion rate stays at or below the rate limit and burst limit, your requests are accepted.
<note>
  For the Elastic Cloud Serverless trial, the rate limit is reduced to 15 MB/s and the burst limit is 30 MB/s.
</note>


### Dynamic rate scaling for Elastic Cloud Hosted

<applies-to>
  - Elastic Cloud Hosted: Preview
</applies-to>

<note>
  This functionality is available in technical preview in Elastic Cloud Hosted deployments versions 9.2 and later.
</note>

For Elastic Cloud Hosted deployments, rate limits can scale up or down dynamically based on backpressure from Elasticsearch. Every deployment starts with a 1 MB/s rate limit and 2 MB/s burst limit. The system automatically adjusts these limits based on your Elasticsearch capacity and load patterns. Scaling requires time, so sudden load spikes might still result in temporary rate limiting.

### Exceeding the rate limit

If you send data that exceeds the available limits, the Elastic Cloud Managed OTLP Endpoint responds with an HTTP `429` Too Many Requests status code. A log message similar to this appears in the OpenTelemetry Collector's output:
```json
{
  "code": 8,
  "message": "error exporting items, request to <ingest endpoint> responded with HTTP Status Code 429"
}
```

The causes of rate limiting differ by deployment type:
- **Elastic Cloud Serverless**: You exceed the 15 MB/s rate limit or 30 MB/s burst limit.
- **Elastic Cloud Hosted**: You send load spikes that exceed current limits (temporary `429`s) or your Elasticsearch cluster can't keep up with the load (consistent `429`s).

After your sending rate goes back to the allowed limit, or after the system scales up the rate limit for Elastic Cloud Hosted, requests are automatically accepted again.

### Solutions to rate limiting

The solutions to rate limiting depend on your deployment type:

#### Elastic Cloud Hosted deployments

For Elastic Cloud Hosted deployments, if you're experiencing consistent `429` errors, the primary solution is to increase your Elasticsearch capacity. Because rate limits are affected by Elasticsearch backpressure, scaling up your Elasticsearch cluster reduces backpressure and, over time, increases the ingestion rate for your deployment.
To scale your deployment:
- [Scaling considerations](https://www.elastic.co/docs/deploy-manage/production-guidance/scaling-considerations)
- [Resize deployment](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/resize-deployment)
- [Autoscaling in ECE and ECH](https://www.elastic.co/docs/deploy-manage/autoscaling/autoscaling-in-ece-and-ech)

Temporary `429`s from load spikes typically resolve on their own as the system scales up, as long as your Elasticsearch cluster has sufficient capacity.

#### Elastic Cloud Serverless deployments

For Elastic Cloud Serverless projects, you can either decrease data volume or request higher limits.
To increase the rate limit, [contact Elastic Support](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/contact-support).