﻿---
title: Set up the EDOT Python agent
description: Learn how to set up and configure the Elastic Distribution of OpenTelemetry (EDOT) Python to instrument your application or service.
url: https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup
products:
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Python
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Python: Generally available
---

# Set up the EDOT Python agent
Learn how to set up the Elastic Distribution of OpenTelemetry (EDOT) Python in various environments, including Kubernetes and others.
Follow these steps to get started.
<warning>
  Avoid using the Python SDK alongside any other APM agent, including Elastic APM agents. Running multiple agents in the same application process may lead to conflicting instrumentation, duplicate telemetry, or other unexpected behavior.
</warning>

<stepper>
  <step title="Install the distribution">
    Install EDOT Python by running pip:
    ```bash
    pip install elastic-opentelemetry
    ```
  </step>

  <step title="Install the available instrumentation">
    EDOT Python doesn't install any instrumentation package by default. Instead, it relies on the `edot-bootstrap` command to scan the installed packages and install the available instrumentation. The following command installs all the instrumentations available for libraries installed in your environment:
    ```bash
    edot-bootstrap --action=install
    ```

    <note>
      Add this command every time you deploy an updated version of your application. Also add it to your container image build process.
    </note>
  </step>

  <step title="Configure EDOT Python">
    Refer to [Observability quickstart](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart) documentation on how to setup your environment.To configure EDOT Python you need to set a few `OTLP_*` environment variables that are available when running EDOT Python:
    - `OTEL_RESOURCE_ATTRIBUTES`: Use this to add a `service.name` and `deployment.environment.name`. This makes it easier to recognize your application when reviewing data sent to Elastic.
    The following environment variables are not required if you are sending data through a local EDOT Collector but are provided in the Elastic Observability platform onboarding:
    - `OTEL_EXPORTER_OTLP_ENDPOINT`: The full URL of the endpoint where data will be sent.
    - `OTEL_EXPORTER_OTLP_HEADERS`: A comma-separated list of `key=value` pairs that will be added to the headers of every request. This is typically used for authentication information.
  </step>

  <step title="Run EDOT Python">
    Wrap your service invocation with `opentelemetry-instrument`, which is the wrapper that provides automatic instrumentation. For example, a web service running with gunicorn might look like this:
    ```bash
    opentelemetry-instrument gunicorn main:app
    ```
  </step>

  <step title="Confirm that EDOT Python is working">
    To confirm that EDOT Python has successfully connected to Elastic:
    1. Go to **Observability** → **Applications** → **Service Inventory**
    2. Find the name of the service to which you just added EDOT Python. It can take several minutes after initializing EDOT Python for the service to show up in this list.
    3. Select the name in the list to see trace data.

    <note>
      There might be no trace data to visualize unless you have invoked your application since initializing EDOT Python.
    </note>
  </step>
</stepper>


## Troubleshooting

For help with common setup issues, refer to the [EDOT Python troubleshooting guide](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/python).