﻿---
title: Migrate to EDOT Python from the Elastic APM Python agent
description: Migrate from the Elastic APM Python agent to the Elastic Distribution of OpenTelemetry Python (EDOT Python).
url: https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/migration
products:
  - APM Agent
  - Elastic Cloud Serverless
  - Elastic Distribution of OpenTelemetry Python
  - Elastic Distribution of OpenTelemetry SDK
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
  - Elastic Distribution of OpenTelemetry Python: Generally available
---

# Migrate to EDOT Python from the Elastic APM Python agent
Learn the differences between the [Elastic APM Python agent](https://www.elastic.co/docs/reference/apm/agents/python) and the Elastic Distribution of OpenTelemetry Python (EDOT Python).
Follow the steps to migrate your instrumentation and settings. For step-by-step instructions on setting up EDOT Python refer to [Setup](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup).

## Migration steps

Follow these steps to migrate:
1. Remove any configuration and setup code needed by Elastic APM Python Agent from your application source code.
2. Migrate any usage of Elastic APM Python Agent API to manual instrumentation with OpenTelemetry API in the application source code.
3. Follow the [setup documentation](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup) on to install and configure EDOT Python.


## Configuration mapping

The following are Elastic APM Python agent settings that you can migrate to EDOT Python.

### Resource attributes when using the EDOT Collector

Ingesting OpenTelemetry data directly through APM Server is [no longer supported](https://www.elastic.co/docs/reference/opentelemetry/architecture#limitations). Historically, when ingesting OpenTelemetry data through the Elastic APM Server, unmapped resource attributes were added under `labels.*`. This behavior does not apply when using the EDOT Collector and is not recommended for new deployments. Use the EDOT Collector or Managed OTLP for supported ingestion.
If you rely on specific attribute mappings for querying or filtering in Elastic Observability, configure explicit attribute processors in the EDOT Collector pipeline.

### `api_key`

The Elastic [`api_key`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-api-key) option corresponds to the OpenTelemetry [`OTEL_EXPORTER_OTLP_HEADERS`](https://opentelemetry.io/docs/concepts/sdk-configuration/otlp-exporter-configuration/#otel_exporter_otlp_headers) environment variable.
For example: `OTEL_EXPORTER_OTLP_HEADERS="Authorization=ApiKey an_api_key"`.

### `capture_headers`

The Elastic [`capture_headers`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-capture-headers) option corresponds to the OpenTelemetry Python `OTEL_INSTRUMENTATION_HTTP_CAPTURE_HEADERS_SERVER_REQUEST` and `OTEL_INSTRUMENTATION_HTTP_CAPTURE_HEADERS_SERVER_RESPONSE` environment variables, refer to [OpenTelemetry documentation](https://github.com/open-telemetry/opentelemetry.io/edit/main/content/en/docs/zero-code/python/example.md/#capture-http-request-and-response-headers).
For sanitization of these captured headers you can use the `OTEL_INSTRUMENTATION_HTTP_CAPTURE_HEADERS_SANITIZE_FIELDS` environment variable.
For example `OTEL_INSTRUMENTATION_HTTP_CAPTURE_HEADERS_SANITIZE_FIELDS=".*session.*,set-cookie"` replaces the value of headers such as `session-id` and `set-cookie` with `[REDACTED]` in the span.

### `cloud_provider`

The Elastic [`cloud_provider`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-cloud-provider) option corresponds to listing individual resource detectors using the OpenTelemetry Python `OTEL_EXPERIMENTAL_RESOURCE_DETECTORS` environment variable, refer to [default value of `OTEL_EXPERIMENTAL_RESOURCE_DETECTORS`](/docs/reference/opentelemetry/edot-sdks/python/configuration#differences-from-opentelemetry-python). The default value is dynamic based on the platform and is analogous to `auto`.

### `django_autoinsert_middleware`

The Elastic [`django_transaction_name_from_route`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-django-autoinsert-middleware) option does not have a correspondent option, but is activated by default in OpenTelemetry Python.

### `django_transaction_name_from_route`

The Elastic [`django_transaction_name_from_route`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-django-transaction-name-from-route) option does not have a correspondent option, but is activated by default in OpenTelemetry Python.

### `enabled`

The Elastic [`enabled`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-enabled) option corresponds to the OpenTelemetry [`OTEL_SDK_DISABLED`](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#general-sdk-configuration) environment variable.

### `environment`

The Elastic [`environment`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-environment) option corresponds to setting the `deployment.environment.name` key in [`OTEL_RESOURCE_ATTRIBUTES`](https://opentelemetry.io/docs/concepts/sdk-configuration/general-sdk-configuration/#otel_resource_attributes).
For example: `OTEL_RESOURCE_ATTRIBUTES=deployment.environment.name=testing`.

### `global_labels`

The Elastic [`global_labels`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-global_labels) option corresponds to adding `key=value` comma separated pairs in [`OTEL_RESOURCE_ATTRIBUTES`](https://opentelemetry.io/docs/concepts/sdk-configuration/general-sdk-configuration/#otel_resource_attributes).
For example: `OTEL_RESOURCE_ATTRIBUTES=alice=first,bob=second`. Such labels will result in resource.attributes.key=value attributes on the server, e.g. resource.attributes.alice=first

### `include_process_args`

The Elastic [`include_process_args`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-include-process-args) option corresponds to include the `ProcessResourceDetector` to `OTEL_EXPERIMENTAL_RESOURCE_DETECTORS` environment variable, refer to the [default value of `OTEL_EXPERIMENTAL_RESOURCE_DETECTORS`](/docs/reference/opentelemetry/edot-sdks/python/configuration#differences-from-opentelemetry-python).

### `metrics_interval`

The Elastic [`metrics_interval`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-metrics_interval) corresponds to the OpenTelemetry [`OTEL_METRIC_EXPORT_INTERVAL`](https://opentelemetry.io/docs/specs/otel/configuration/sdk-environment-variables/#periodic-exporting-metricreader) environment variable.
For example: `OTEL_METRIC_EXPORT_INTERVAL=30000`.

### `sanitize_field_names`

The Elastic [`sanitize_field_names`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-sanitize-field-names) option does not have a complete equivalent. For captured headers sanitization, refer to [capture_headers](#capture_headers).

### `secret_token`

The Elastic [`secret_token`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-secret-token) option corresponds to the OpenTelemetry [`OTEL_EXPORTER_OTLP_HEADERS`](https://opentelemetry.io/docs/concepts/sdk-configuration/otlp-exporter-configuration/#otel_exporter_otlp_headers) environment variable.
For example: `OTEL_EXPORTER_OTLP_HEADERS="Authorization=ApiKey an_apm_secret_token"`.

### `server_timeout`

The Elastic [`server_timeout`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-server-timeout) option corresponds to the OpenTelemetry [`OTEL_EXPORTER_OTLP_TIMEOUT`](https://opentelemetry.io/docs/languages/sdk-configuration/otlp-exporter/#otel_exporter_otlp_timeout) environment variable.

### `server_url`

The Elastic [`server_url`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-server-url) option corresponds to the OpenTelemetry [`OTEL_EXPORTER_OTLP_ENDPOINT`](https://opentelemetry.io/docs/concepts/sdk-configuration/otlp-exporter-configuration/#otel_exporter_otlp_endpoint) environment variable.

### `service_name`

The Elastic [`service_name`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-service-name) option corresponds to the OpenTelemetry [`OTEL_SERVICE_NAME`](https://opentelemetry.io/docs/concepts/sdk-configuration/general-sdk-configuration/#otel_service_name) environment variable.
You can also set the service name using [`OTEL_RESOURCE_ATTRIBUTES`](https://opentelemetry.io/docs/concepts/sdk-configuration/general-sdk-configuration/#otel_resource_attributes).
For example: `OTEL_RESOURCE_ATTRIBUTES=service.name=myservice`. If `OTEL_SERVICE_NAME` is set, it takes precedence over the resource attribute.

### `service_version`

The Elastic [`service_version`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-service-version) option corresponds to setting the `service.version` key in [`OTEL_RESOURCE_ATTRIBUTES`](https://opentelemetry.io/docs/concepts/sdk-configuration/general-sdk-configuration/#otel_resource_attributes).
For example: `OTEL_RESOURCE_ATTRIBUTES=service.version=1.2.3`.

### `transaction_ignore_urls` and `transactions_ignore_patterns`

The Elastic [`transaction_ignore_urls`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-transaction-ignore-urls) and [`transactions_ignore_patterns`](https://www.elastic.co/docs/reference/apm/agents/python/configuration#config-transactions-ignore-patterns) options correspond to setting the [`OTEL_PYTHON_EXCLUDED_URLS`](https://opentelemetry.io/docs/zero-code/python/configuration/#excluded-urls) environment variable.

## Performance overhead

Evaluate the [differences in performance overhead](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/overhead) between EDOT Python and Elastic APM Python agent.

## Limitations

The following limitations apply when migrating to EDOT Python.

### Central and dynamic configuration

You can manage EDOT Python configurations through the [central configuration feature](https://www.elastic.co/docs/solutions/observability/apm/apm-agents/central-configuration) in the Applications UI.
Refer to [Central configuration](https://www.elastic.co/docs/reference/opentelemetry/central-configuration) for more information.

### AWS Lambda

A custom lambda layer for the Elastic Distribution of OpenTelemetry Python is not currently available. Refer to the [Lambda Auto-Instrumentation](https://opentelemetry.io/docs/faas/lambda-auto-instrument/).

### Missing instrumentations

The following libraries are currently missing an OpenTelemetry equivalent:
- Azure storage and Azure queue
- `aiobotocore`
- `aiomysql`
- `aioredis`
- `Graphene`
- `httplib2`
- `pylibmc`
- `pyodbc`
- `python-memcached`
- `Sanic`
- `zlib`


### Integration with structured logging

EDOT Python lacks a [structlog integration](https://www.elastic.co/docs/reference/apm/agents/python/logs#structlog) at the moment.

### Span compression

EDOT Python does not implement [span compression](https://www.elastic.co/docs/solutions/observability/apm/spans#apm-spans-span-compression).

### Breakdown metrics

EDOT Python is not sending metrics that power the [Breakdown metrics](https://www.elastic.co/docs/solutions/observability/apm/metrics#_breakdown_metrics).

## Troubleshooting

If you're encountering issues during migration, refer to the [EDOT Python troubleshooting guide](https://www.elastic.co/docs/troubleshoot/ingest/opentelemetry/edot-sdks/python).